/*#################################################################                                          
  Project: EDMA Kompass
  Author: Bastian Kramer
  Version: 3.0.0
  Date: 09.08.2018
#################################################################*/	

//#################################################################
//COMPILE WITH:     gcc -o KOMPASS KOMPASS.c -lm
//#################################################################

#define VERSION "4.0.0"

#include <stdio.h>
#include <stdlib.h>
#include <linux/i2c-dev.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/shm.h>
#include <stropts.h>
#include <math.h>
#include "KOMPASS.h"
#include <time.h>
#include <linux/i2c-dev.h>
#include <linux/i2c.h>

#define SHMSZ     4

/**********************************************************
Steuerbyte 0:	0	Read/Write freigabe Byte
Steuerbyte 1:	99 	Programm beenden
Datenbyte 0: 	(shm+2)	Breitengrad
Datenbyte 1: 	(shm+3)	Lngengrad

**********************************************************/

//################ Kompass ########################################
volatile int fd; //file descriptor
volatile int fd2;
char *i2c_device = "/dev/i2c-1";
unsigned char buf[10];
signed char *shm;
signed char *shm_EdMa;
char gKompass = 0;
char gLoggen = 0;
char gLogThis = 2;
unsigned int gR16 = 0;
unsigned int gR17 = 0;
float gR8 = 0;

void Log(char *aLog, ...)
{
	
}

void i2c_write(unsigned int value, unsigned int target_register)
{
	buf[0] = target_register;
	buf[1] = value;
	if (write(fd, buf, 2) != 2)
		Log("Writing");
	usleep(100);
}

unsigned char i2c_read(unsigned char aRegister)
{
	unsigned char lBuf[1];
	
	lBuf[0] = aRegister;
	if (write(fd, lBuf, 1) != 1)
	usleep(100);	
	if (read(fd, lBuf, 1) != 1)
			Log("I2C_ERR: Werte auslesen\n");	
	return lBuf[0];
}

void I2C_Init()
{
	Log("*** Kompass Init ***\n");

	if ((fd = open(i2c_device, O_RDWR)) < 0)
	{
		Log("Failed to open I2C-Device (fd)\n");
		exit(1);
	}
	
	if ((fd2 = open(i2c_device, O_RDWR)) < 0)
	{
		Log("Failed to open I2C-Device (fd2)\n");
		exit(1);
	}
	
	//AD-Wandler
	if (ioctl(fd2, I2C_SLAVE, 0x68) < 0)
	{
		Log("Unable to get bus access to talk to slave AD-Wandler\n");
		exit(1);
	}
	
	if (gKompass == 0)
	{
		if (ioctl(fd, I2C_SLAVE, HMC5883_SLAVE_ADR) < 0)
		{
			Log("Unable to get bus access to talk to slave HMC\n");
			exit(1);
		}
	}
	else
	{
		if (ioctl(fd, I2C_SLAVE, QMC5883_SLAVE_ADR) < 0)
		{
			Log("Unable to get bus access to talk to slave QMC\n");
			exit(1);
		}
	}
}

void printb(char a)
{
		for(int i=(sizeof(a) * 8) - 1; i >= 0;Log("%",(a & (0x1 << i--)) > 0)); Log("\n");
}

int set_wait(int duration)
{
	time_t sec;
	sec = time(NULL);
	return sec + duration;
}

char check_wait(int wert)
{
	time_t sec;
	sec = time(NULL);
	return sec < wert;
}

int main(int Anz, char* Werte[])
{
int shmid, shmide;
key_t key;
signed short int x, y, z;
signed short int temperature;
signed short int winkel;
int timeout;
int prtWinkel = 1000;
unsigned char charTmp = 0;
short int AD_Bat = 0;
short int AD_Maehmotor = 0;
short int AD_M_Links = 0;
short int AD_M_Rechts = 0;
short int AD_tmp = 0;
int dl = 0;

	//Version
	if (Anz > 1)
	{
		if (Werte[1][0] == 'v')
		{
			printf("KOMPASS %s\n", VERSION);
			exit(0);
		}
	}
	
	//Prfen, ob mit den Richtigen Paramtern aufgerufen wurde
	if(Anz < 2)
	{
		Log("Kompass, es wurde keine Speicherkennung uebergeben! Client: %i\n",atoi(Werte[1]));
		return -1;
	}
	key = atoi(Werte[1]);
	gKompass = atoi(Werte[2]);
	gR16 = atoi(Werte[3]);
	gR17 = atoi(Werte[4]);
	
	gR8 = 0.01;
	if (gR16 <= 0) gR16 = 15;
	if (gR17 <= 0) gR17 = 120;
	
	// shared memmory einrichten **********************************************************
	// ffnet den gemeinsamen speicher ----------------------------------------------------
    if ((shmid = shmget(key, SHMSZ, 0666)) < 0) 						// int    shmget(key_t, size_t, int);
	{
        Log("KOMPASS: shmget");
        Log("KOMPASS, Fehler beim oeffnen des shared memmory, Client: %i\n",atoi(Werte[1]));
				return -2;
    }
		// bindet den speicher ein (shmat = shm attach) ---------------------------------------
    if ((shm = shmat(shmid, 0, 0)) == (signed char *) -1) 
	{
        Log("KOMPASS: shmat");
        Log("KOMPASS, Fehler beim einbinden des shared memmory, Client: %i\n",atoi(Werte[1]));
				return -3;
    }
	
	gLoggen = *(shm+12);
	Log("Starte Kompass...\n");
	
	//Init I2C
	I2C_Init();
	
	if (gKompass == 0)
	{
		//Init Kompass HCM
		//Config A
		i2c_write(16, HMC5883_REG_CONFA);
		charTmp = i2c_read(HMC5883_REG_CONFA);
		Log("A: %\n", charTmp);
		//printb(charTmp);
	
		//Config B
		i2c_write(32, HMC5883_REG_CONFB);
		charTmp = i2c_read(HMC5883_REG_CONFB);
		Log("B: %\n", charTmp);
		//printb(charTmp);
	
		//Mode
		charTmp = i2c_read(HMC5883_REG_MODE);
		Log("M: %\n", charTmp);
		//printb(charTmp);
	}
	else
	{
		//Init Kompass QMC
		//Reg 1
		i2c_write(0b00010001, QMC5883_REG_CONF1);
		charTmp = i2c_read(QMC5883_REG_CONF1);
		Log("B: %\n", charTmp);
		//printb(charTmp);
		
		//Periode
		i2c_write(1, QMC5883_REG_PERIOD);
		charTmp = i2c_read(QMC5883_REG_PERIOD);
		Log("B: %\n", charTmp);
		//printb(charTmp);
	}
	
	//Werte ermitteln und bertragen, bis Abbruchsignal empfangen wird
	while (*(shm+1) != 99)
	{		
		if (gKompass == 0)
		{
			//HMC
			charTmp = i2c_read(HMC5883_REG_STATUS);
			if (charTmp & 1)
			{
				i2c_write(1, HMC5883_REG_MODE);
				timeout = set_wait(5);	//Timeout auf 5 sec.
				charTmp = i2c_read(HMC5883_REG_STATUS);
				
				while(((charTmp & 1) == 0) && check_wait(timeout))
				{
					charTmp = i2c_read(HMC5883_REG_STATUS);
				}
			}
		}
		else
		{
			//QMC
			charTmp = i2c_read(QMC5883_REG_STATUS);
			timeout = set_wait(5);	//Timeout auf 5 sec.
			while(((charTmp & 1) == 0) && check_wait(timeout))
			{
				charTmp = i2c_read(QMC5883_REG_STATUS);
			}
		}
		
		if (check_wait(timeout) && charTmp > 0)
		{
			if (gKompass == 0)
			{
				buf[0] = 0; buf[1] = 0; buf[2] = 0; buf[3] = 0; buf[4] = 0; buf[5] = 0;
				buf[0] = HMC5883_REG_DATA;
				if (write(fd, buf, 1) != 1)
					Log("err\n");
				
				if (read(fd, buf, 6) != 6)
					Log("I2C_ERR: Werte auslesen");
				x = (buf[0] << 8) | buf[1];
				z = (buf[2] << 8) | buf[3];
				y = (buf[4] << 8) | buf[5];
			}
			else
			{
				buf[0] = QMC5883_REG_DATA;
				if (write(fd, buf, 1) != 1)
					Log("I2C_ERR: Werte auslesen");
				
				if (read(fd, buf, 6) != 6)
					Log("I2C_ERR: Werte auslesen");
				x = (buf[1] << 8) + buf[0];
				y = (buf[3] << 8) + buf[2];
				z = (buf[5] << 8) + buf[4];
				
				//Temp
				buf[0] = QMC5883_REG_TEMP;
				if (write(fd, buf, 1) != 1)
					Log("I2C_ERR: Werte auslesen");
				
				if (read(fd, buf, 2) != 2)
					Log("I2C_ERR: Werte auslesen");
				temperature = (buf[1] << 8) | buf[0];
				//printf("T: %i\n", temperature);
			}
			
			//Winkel berechnen
			winkel=atan2(x, y) * (180 / M_PI) + 180;
	
			/*if (prtWinkel > 10)
			{	prtWinkel = 0;
				printf("W: %i X: %i Y: %i K: %i\n", winkel, x, y, gKompass);
			}
			prtWinkel++;
			*/
		}		
		else
		{
			Log("Kompass -> timeout\n");
		}
		
		//printf("AD\n");
		//AD-Wandler
		//Batterie
		buf[0] = 128 + 64 + 32;//CH4
		buf[1] = 128 + 64 + 32;
		buf[2] = 0;
		write(fd2, buf, 1);
		usleep(5000);	
		read(fd2, buf, 3);// != 3
		AD_Bat = ((buf[0] << 8) | buf[1]);
		if (AD_Bat >= 32768)
			AD_Bat = 65536 - AD_Bat;
		AD_Bat = (2 * 2.048 * AD_Bat * 100) / 4096;	//2 ** 12
		AD_Bat = (AD_Bat * (gR16 + gR17)) / gR16;
		//printf("BAT --> MSB: %i LSB:%i CONF: %i Spg: %i.%i\n", buf[0], buf[1], buf[2], AD_Bat / 100, AD_Bat % 100);
		
		//Mhmotor
		AD_Maehmotor = 0;
		for (dl = 0; dl < 10; dl++)
		{
			buf[0] = 128 + 64;//CH3
			buf[1] = 128 + 64;
			write(fd2, buf, 1);
			usleep(5000);	
			read(fd2, buf, 3);// != 3
			AD_tmp = ((buf[0] << 8) | buf[1]);
			if (AD_tmp >= 32768)
				AD_tmp = 65536 - AD_tmp;
			AD_tmp = (2 * 2.048 * AD_tmp * 100) / 4096;	//2 ** 12
			AD_tmp = (AD_tmp / gR8);
			AD_Maehmotor += AD_tmp;
		}
		AD_Maehmotor /= 10;
		//Log("Maeh --> MSB: % LSB:% CONF: % Spg: %.%\n", buf[0], buf[1], buf[2], AD_Maehmotor / 100, AD_Maehmotor % 100);
		
		//Motor links
		AD_M_Links = 0;
		for (dl = 0; dl < 2; dl++)
		{
			buf[0] = 128 + 32;//CH2
			buf[1] = 128 + 32;
			write(fd2, buf, 1);
			usleep(5000);	
			read(fd2, buf, 3);// != 3
			AD_tmp = ((buf[0] << 8) | buf[1]);
			if (AD_tmp >= 32768)
				AD_tmp = 65536 - AD_tmp;
			AD_tmp = (2 * 2.048 * AD_tmp * 100) / 4096;	//2 ** 12
			AD_tmp = (AD_tmp * 10);
			AD_M_Links += AD_tmp;
		}
		AD_M_Links /= 2;
		//Log("ML --> MSB: % LSB:% CONF: % Spg: %.%\n", buf[0], buf[1], buf[2], AD_M_Links / 100, AD_M_Links % 100);

		
		//Motor rechts
		AD_M_Rechts = 0;
		for (dl = 0; dl < 2; dl++)
		{
			buf[0] = 128;//CH1
			buf[1] = 128;
			write(fd2, buf, 1);
			usleep(5000);	
			read(fd2, buf, 3);// != 3
			AD_tmp = ((buf[0] << 8) | buf[1]);
			if (AD_tmp >= 32768)
				AD_tmp = 65536 - AD_tmp;
			AD_tmp = (2 * 2.048 * AD_tmp * 100) / 4096;	//2 ** 12
			AD_tmp = (AD_tmp * 10);
			AD_M_Rechts += AD_tmp;
		}
		AD_M_Rechts /= 2;
		//Log("ML --> MSB: % LSB:% CONF: % Spg: %.%\n", buf[0], buf[1], buf[2], AD_M_Rechts / 100, AD_M_Links % 100);
	
		//Daten senden
		*(shm+0) = 1;			// still alive
		*(shm+2) = winkel;
		*(shm+3) = winkel >>8;
		*(shm+4) = AD_Bat;
		*(shm+5) = AD_Bat >>8;
		*(shm+6) = AD_Maehmotor;
		*(shm+7) = AD_Maehmotor >>8;
		*(shm+8) = AD_M_Links;
		*(shm+9) = AD_M_Links >>8;
		*(shm+10) = AD_M_Rechts;
		*(shm+11) = AD_M_Rechts >>8;
		gLoggen = *(shm+12);
	}
	Log("Ende Kompass % \n",atoi(Werte[1]));
 
}

