/*#################################################################                                        
  Project: EDMA - PWM
  Author: Wilfried Menken
  Version: 3.0.0
  Date: 09.08.2018
#################################################################*/

//#################################################################
//COMPILE WITH:     gcc -o PWM PWM.c
//#################################################################

#define VERSION "4.0.0"

#include <sys/shm.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <unistd.h>

// Access from ARM Running Linux
									 
#define BCM2708_PERI_BASE        0x20000000			// Pi_2  0x3F000000
#define GPIO_BASE                (BCM2708_PERI_BASE + 0x200000) /* GPIO controller */
#define PAGE_SIZE (4*1024)
#define BLOCK_SIZE (4*1024)

int  mem_fd;
void *gpio_map;

// I/O access
volatile unsigned *gpio;

// GPIO setup macros. Always use INP_GPIO(x) before using OUT_GPIO(x) or SET_GPIO_ALT(x,y)
#define INP_GPIO(g) *(gpio+((g)/10)) &= ~(7<<(((g)%10)*3))
#define OUT_GPIO(g) *(gpio+((g)/10)) |=  (1<<(((g)%10)*3))
#define SET_GPIO_ALT(g,a) *(gpio+(((g)/10))) |= (((a)<=3?(a)+4:(a)==4?3:2)<<(((g)%10)*3))

#define GPIO_SET *(gpio+7)  // sets   bits which are 1 ignores bits which are 0
#define GPIO_CLR *(gpio+10) // clears bits which are 1 ignores bits which are 0

//By BK--->
#define GPIO_PULLUP *(gpio+37)	//00 = No Pullup   01 = Pull Down  10 = PullUp
#define GPIO_PULLUP_CL *(gpio+38)	//Set Clock and Clear Clock Notwendig, damit Pullup bernommen wird

void setup_io();

//**********************************************************************

#define SHMSZ     3


unsigned int wert = 0;
unsigned long int gpio_base = 0;
unsigned char gRaspi = 0;

/**********************************************************
gcc -o blinker blinker.c -lwiringPi

Steuerbyte 0:	0	Read/Write freigabe Byte
Steuerbyte 1:	1 	ohne Anfahrrampe
							2 	mit Anfahrrampe
							3
							99 	Programm beenden
							
Byte 2: 			-100 bis +100 Wert



**********************************************************/

signed char Rampe(signed char Alterwert, signed char Neuerwert, signed char Steigung, unsigned char Relais)
{
unsigned int tmpNeuerwert = 0;
static unsigned int warten = 0;
unsigned char Nulldurchgang = 0;
signed int LetzterWert = 0;
	
	if(Steigung > 0)
	{
		if(warten > 0)
			warten--;
		else
		{
			if(Alterwert < Neuerwert)
			{
				Alterwert += Steigung;
				if(Alterwert > Neuerwert)
					Alterwert = Neuerwert;
			}
			else
			{
				Alterwert -= Steigung;
				if(Alterwert < Neuerwert)
					Alterwert = Neuerwert;
			}
			
			if(Relais == 0 && Alterwert < 0)
				warten = 100;							// 100 = 100ms pause frs Relais zum umschalten
				
			else if(Relais == 1 && Alterwert > 0)
				warten = 100;							// 100 = 100ms pause frs Relais zum umschalten
							
		}
	}
	else																		// ohne Rampe
		Alterwert = Neuerwert;
		
	if(Alterwert < -100) Alterwert = -100;	// min Wert
	if(Alterwert > 100) Alterwert = 100;		// max Wert

	
	return Alterwert;
}

int main(int Anz, char* Werte[])
{
int shmid;
key_t key;
	int *s;
signed char *shm;
signed char PwmWert = 0;
char RichtungEinmal = 0;
char PWMPort = 0;
char richtung = 0;
signed char shmAlt = 0;
static unsigned char StatusRelais = 0;

	//Version
	if (Anz > 1)
	{
		if (Werte[1][0] == 'v')
		{
			printf("PWM %s\n", VERSION);
			exit(0);
		}
	}
	
	//Paramter einlesen
	key = atoi(Werte[1]);
	wert = key;
	
	gRaspi = atoi(Werte[2]);
	
	//Register einstellen fr versch. Raspis
	if (gRaspi < 2)
		gpio_base = 0x20000000 + 0x200000;
	else	
		gpio_base = 0x3F000000 + 0x200000;	
	
	// Set up gpi pointer for direct register access
	setup_io();


	//Pin7 interne Pullups aus
	GPIO_PULLUP = 0;	//Pullup aus
	GPIO_PULLUP_CL |= (1 << 7);	//bernehmen
	GPIO_PULLUP_CL &= ~(1 << 7);	//bernehmen rcksetzen
	
    

		if(Anz < 2)
		{
			printf("es wurde keine Speicherkennung uebergeben!");
			return -1;
		}


		
		//printf("Start Client: %i - %s - \n", atoi(Werte[1]), Werte[2]);

		// shared memmory einrichten **********************************************************
		// ffnet den gemeinsamen speicher ----------------------------------------------------
    if ((shmid = shmget(key, SHMSZ, 0666)) < 0) 						// int    shmget(key_t, size_t, int);
		{
        perror("shmget");
        printf("Fehler beim oeffnen des shared memmory, Client: %i\n",atoi(Werte[1]));
				return -2;
    }
		// bindet den speicher ein (shmat = shm attach) ---------------------------------------
    if ((shm = shmat(shmid, 0, 0)) == (signed char *) -1) 
		{
        perror("shmat");
        printf("Fehler beim einbinden des shared memmory, Client: %i\n",atoi(Werte[1]));
				return -3;
    }

	//wiringPiSetup();

	if(key == 1001)																						// Motor links
	{
		PWMPort = 27; //21   // 27;//2;	//0;
		richtung = 17; //17   //0;	//1;
	}
	else if(key == 1002)																			// Motor rechts
	{
		PWMPort = 22; //22   //3;	//2;
		richtung = 18;//18   1;	//3;
	}
	else if(key == 1003)																			// Mhwerk
	{
		PWMPort = 23;//23    4;
		RichtungEinmal = 0;//17   0;
	}
		
	//pinMode (PWMPort, OUTPUT);																// Pins als Ausgang definieren
	//pinMode (richtung, OUTPUT);
	INP_GPIO(PWMPort); // must use INP_GPIO before we can use OUT_GPIO
    OUT_GPIO(PWMPort);
	INP_GPIO(richtung); // must use INP_GPIO before we can use OUT_GPIO
    OUT_GPIO(richtung);
	
	while (*(shm+1) != 99)
	{
//		usleep(1000);
		
		*(shm+0) = 1;																					// still alive

		if(shmAlt != *(shm+2))																	// wenn sich Werte fr die PWM ndern, diese anzeigen
		{
			shmAlt = *(shm+2);
			//printf("Client: %i - %i - %i - %i \n", key, *(shm+0), *(shm+1), *(shm+2)); 
		}
		
		PwmWert = Rampe(PwmWert, *(shm+2), *(shm+1), StatusRelais);				// +/-100 Schritte	
		
		if(key != 1003)																					// wenn nicht Mhmotor ...
		{
			if(PwmWert > 0)																				// wenn positiver Wert, ...
			{
				//digitalWrite (richtung, LOW);											// ... umschalten auf vorwrts fahren
				GPIO_CLR = 1 << richtung;
				StatusRelais = 0;
			}
			if(PwmWert < 0)																				// wenn negativer Wert, ...
			{
				//digitalWrite (richtung, HIGH);												// ... umschalten auf rckwrts fahren
				GPIO_SET = 1 << richtung;
				StatusRelais = 1;
			}
		}
		
		if(abs(PwmWert) > 95)
		{													// bei Wert > 95 Ausgang ein
			usleep(1000);
			//digitalWrite (PWMPort,  HIGH) ;												
			GPIO_SET = 1 << PWMPort;
		}
		else if(abs(PwmWert) < 5)							// bei Wert < 5 Ausgang aus
		{
			usleep(1000);
			//digitalWrite (PWMPort,  LOW) ;												
			GPIO_CLR = 1 << PWMPort;
		}
		else																										// sonst normales PWM ausgeben
		{
			//digitalWrite (PWMPort, HIGH) ; delay(abs(PwmWert)/10);
//			GPIO_SET = 1 << PWMPort; usleep((abs(PwmWert)/10)*1000);
			GPIO_SET = 1 << PWMPort; usleep((abs(PwmWert))*100);
			
			//digitalWrite (PWMPort,  LOW) ; delay(10 - abs(PwmWert)/10);
//			GPIO_CLR = 1 << PWMPort; usleep((10 - abs(PwmWert)/10)*1000);
			GPIO_CLR = 1 << PWMPort; usleep((100 - abs(PwmWert))*100);
		}
			
	}
	//printf("Ende Client: %i - %i - %i - %i \n", key, *(shm+0), *(shm+1), *(shm+2));	// Ende des Thrads anzeigen 
	return 0;
 
}

//
// Set up a memory regions to access GPIO
//
void setup_io()
{
   /* open /dev/mem */
   if ((mem_fd = open("/dev/mem", O_RDWR|O_SYNC) ) < 0) {
      printf("can't open /dev/mem \n");
      exit(-1);
   }

   /* mmap GPIO */
   gpio_map = mmap(
      NULL,             //Any adddress in our space will do
      BLOCK_SIZE,       //Map length
      PROT_READ|PROT_WRITE,// Enable reading & writting to mapped memory
      MAP_SHARED,       //Shared with other processes
      mem_fd,           //File to map
      gpio_base         //Offset to GPIO peripheral
   );

   close(mem_fd); //No need to keep mem_fd open after mmap

   if (gpio_map == MAP_FAILED) {
      printf("mmap error %d\n", (int)gpio_map);//errno also set!
      exit(-1);
   }

   // Always use volatile pointer!
   gpio = (volatile unsigned *)gpio_map;


} // setup_io