/*#################################################################                                        
  Project: EDMA - DIN
  Author: Wilfried Menken, Bastian Kramer
  Version: 4.1.0
  Date: 04.12.2020
#################################################################*/

//#################################################################
//COMPILE WITH:     gcc -o DIN DIN.c
//#################################################################

#define VERSION "4.1.1"

#include <sys/shm.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/ipc.h>

#define SHMSZ     10

// Access from ARM Running Linux

#define BCM2708_PERI_BASE        0x20000000		// Pi_2     0x3F000000
#define GPIO_BASE                (BCM2708_PERI_BASE + 0x200000) /* GPIO controller */


#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <unistd.h>

#define PAGE_SIZE (4*1024)
#define BLOCK_SIZE (4*1024)

#include <time.h>
#include <sys/time.h>
#include <sys/timeb.h>

int  mem_fd;
void *gpio_map;
unsigned long int gpio_base = 0;
unsigned char gRaspi = 0;


// I/O access
volatile unsigned *gpio;


// GPIO setup macros. Always use INP_GPIO(x) before using OUT_GPIO(x) or SET_GPIO_ALT(x,y)
#define INP_GPIO(g) *(gpio+((g)/10)) &= ~(7<<(((g)%10)*3))
#define OUT_GPIO(g) *(gpio+((g)/10)) |=  (1<<(((g)%10)*3))
#define SET_GPIO_ALT(g,a) *(gpio+(((g)/10))) |= (((a)<=3?(a)+4:(a)==4?3:2)<<(((g)%10)*3))

#define GPIO_SET *(gpio+7)  // sets   bits which are 1 ignores bits which are 0
#define GPIO_CLR *(gpio+10) // clears bits which are 1 ignores bits which are 0
#define GPIO_IN *(gpio+13)

//By BK--->
#define GPIO_PULLUP *(gpio+37)	//00 = No Pullup   01 = Pull Down  10 = PullUp
#define GPIO_PULLUP_CL *(gpio+38)	//Set Clock and Clear Clock Notwendig, damit Pullup bernommen wird

void setup_io();

/**********************************************************

Steuerbyte 0:	0	Read/Write freigabe Byte
Steuerbyte 1:	99 	Programm beenden
Datenbyte 0: Sensor links 	(shm+2)
Datenbyte 1: Sensor rechts 	(shm+3)
Datenbyte 2: Gegenfahrensor	(shm+4)
Datenbyte 3: 	(shm+5)
Datenbyte 4: 	(shm+6)

**********************************************************/


unsigned long long int GetElapsedMicroSeconds()
{
struct timeval timer_usec; 
long long int timestamp_usec; /* timestamp in microsecond */
 
  if (!gettimeofday(&timer_usec, NULL)) {
    timestamp_usec = ((long long int) timer_usec.tv_sec) * 1000000ll + 
                        (long long int) timer_usec.tv_usec;
  }
  else {
    timestamp_usec = -1;
  }
  return timestamp_usec;
}

unsigned long long int GetElapsedMilliSeconds()
{
struct timeb timer_msec;
long long int timestamp_msec; /* timestamp in millisecond. */

	if (!ftime(&timer_msec)) {
		timestamp_msec = ((long long int) timer_msec.time) * 1000ll + 
                        (long long int) timer_msec.millitm;
	}
	else {
		timestamp_msec = -1;
	}
	return timestamp_msec;
}

unsigned long long int GetElapsedSeconds()
{
	return GetElapsedMilliSeconds() / 1000;
}

int main(int Anz, char* Werte[])
{
int shmid, g;
key_t key;
int *s;
signed char *shm;
unsigned char lAnt_L 			= 0;
unsigned char lGegen 			= 0;
unsigned char lStart 			= 0;
unsigned char lNotAus 			= 0;
unsigned char lMode 			= 0;
unsigned long gEntprellen 		= 0;
unsigned long cntEntprellen 	= 0;
unsigned long cntEntprellen2 	= 0;
unsigned long cntEntprellen3 	= 0;
unsigned long cntEntprellen4	= 0;
unsigned char lZweiter			= 0;
unsigned int AntL_Up 			= 0;
unsigned long long int musec 	= 0;
unsigned long long int lVerz0 	= 0;
unsigned long long int lVerz1 	= 0;
unsigned long long int lWarten 	= 0;
unsigned char lImpuls 			= 0;
unsigned short lVerzA			= 0;

	//Version
	if (Anz > 1)
	{
		if (Werte[1][0] == 'v')
		{
			printf("DIN %s\n", VERSION);
			exit(0);
		}
	}
	
	if(Anz < 2)
	{
		printf("DIN, es wurde keine Speicherkennung uebergeben! Client: %i\n",atoi(Werte[1]));
		return -1;
	}

	key = atoi(Werte[1]);
	gRaspi = atoi(Werte[2]);
	gEntprellen = atol(Werte[3]);
		if (gEntprellen < 100) gEntprellen = 100;
		
	//Register einstellen fr versch. Raspis
	if (gRaspi < 2)
		gpio_base = 0x20000000 + 0x200000;
	else	
		gpio_base = 0x3F000000 + 0x200000;
	
	
	//printf("DIN, Starte Client %i Parameter: %s -\n", atoi(Werte[1]), Werte[2]);

		// shared memmory einrichten **********************************************************
		// ffnet den gemeinsamen speicher ----------------------------------------------------
    if ((shmid = shmget(key, SHMSZ, 0666)) < 0) 													// int    shmget(key_t, size_t, int);
		{
        perror("shmget");
        printf("DIN, Fehler beim oeffnen des shared memmory, Client: %i\n",atoi(Werte[1]));
				return -2;
    }
		// bindet den speicher ein (shmat = shm attach) ---------------------------------------
    if ((shm = shmat(shmid, 0, 0)) == (signed char *) -1) 
		{
        perror("shmat");
        printf("DIN, Fehler beim einbinden des shared memmory, Client: %i\n",atoi(Werte[1]));
				return -3;
    }

	setup_io();
	  // Set GPIO pins 7-11 to output
	for (g=10; g<=14; g++)
	{
		INP_GPIO(g); // must use INP_GPIO before we can use OUT_GPIO
		//OUT_GPIO(g);
	}
	
	//IN_3 Pullup einschalten
	GPIO_PULLUP = 2;	//Pullup ein
	GPIO_PULLUP_CL |= (1 << 11);	//bernehmen
	GPIO_PULLUP_CL &= ~(1 << 11);	//bernehmen rcksetzen
	
	//IN_1 Pullup einschalten
	INP_GPIO(7);
	GPIO_PULLUP = 2;	//Pullup ein
	GPIO_PULLUP_CL |= (1 << 7);	//bernehmen
	GPIO_PULLUP_CL &= ~(1 << 7);	//bernehmen rcksetzen
	
	//IN_1 Pullup einschalten
	INP_GPIO(8);
	GPIO_PULLUP = 2;	//Pullup ein
	GPIO_PULLUP_CL |= (1 << 8);	//bernehmen
	GPIO_PULLUP_CL &= ~(1 << 8);	//bernehmen rcksetzen
	
	
	lAnt_L 	= 0;		// 0 = kein Signal oder auen	1 = auen	2 = innen
	lImpuls	= 250;		//Impulslnge ist abhngig von der Begrenzungsdrahtlnge
	lVerzA	= 500;		//Soll kurzzeitige Falschmeldungen unterdrcken
	lZweiter = 0;
	
	lVerz0 = GetElapsedMilliSeconds();
	lVerz1 = GetElapsedMilliSeconds();
	
	lStart 	= 0;
	lGegen 	= 0;
	lNotAus = 0;
	lAnt_L 	= 0;
	
	while (*(shm+1) != 99)
	{
		if (lMode)
		{
			if (!((GPIO_IN >>9) & 1) || !((GPIO_IN >>10) & 1))
			{
				cntEntprellen4++;
				if (cntEntprellen4 > gEntprellen)
					if (!((GPIO_IN >>9) & 1) || !((GPIO_IN >>10) & 1))
						lAnt_L = 1;
			}
			else
			{
				lAnt_L = 0;
				cntEntprellen4 = 0;
			}
		}
		else
		{
			//Antenne neue Drahterkennung
			//Auf nchsten High Iompuls warten
			musec = GetElapsedMilliSeconds();
			while (!((GPIO_IN >> 9) & 1) && (GetElapsedMilliSeconds() - musec) < 5)
			{
				//Gegenfahrsensor in dieser Zeit abfragen
				lGegen = 0;
				if (!((GPIO_IN >>11) & 1))
				{
					cntEntprellen++;
					if (cntEntprellen > gEntprellen)
						if (!((GPIO_IN >>11) & 1))
						{
							lGegen = 1;
							*(shm+6) = lGegen;
						}
				}
				else
				{
					cntEntprellen = 0;
				}
			};
			
			//High Lnge auswerten
			if (((GPIO_IN >> 9) & 1))
			{
				musec = GetElapsedMicroSeconds();
				while (((GPIO_IN >> 9) & 1) && (GetElapsedMicroSeconds() - musec) < 30000);
				AntL_Up = GetElapsedMicroSeconds() - musec;
				
				if (AntL_Up < lImpuls)
				{
					if (lZweiter >= 1)
					{
						lZweiter = 0;
						lVerz0 = GetElapsedMilliSeconds();
						lVerz1 = GetElapsedMilliSeconds();
						lAnt_L = 2;
						lZweiter = 1;
					}
					lZweiter++;
				}
				else
				{
					lZweiter = 0;
				}
			}

			if (GetElapsedMilliSeconds() - lVerz1 > lVerzA)
			{
				if (lAnt_L == 2) 
				{
					lAnt_L = 1;
					lVerz0 = GetElapsedMilliSeconds();
				}
			}
			 
			if (GetElapsedMilliSeconds() - lVerz0 > 5000)
			{				
				lAnt_L = 0;
				lVerz0 = GetElapsedMilliSeconds();
			}
		}
		//Ende Antenne
		
		//Sensoren
		if (!((GPIO_IN >>11) & 1))
		{
			cntEntprellen++;
			if (cntEntprellen > gEntprellen)
				if (!((GPIO_IN >>11) & 1))
					lGegen = 1;
		}
		else
		{
			lGegen = 0;
			cntEntprellen = 0;
		}
		
		if (!((GPIO_IN >>7) & 1))
		{
			cntEntprellen2++;
			if (cntEntprellen2 > gEntprellen)
				if (!((GPIO_IN >>7) & 1))
					lStart = 1;
		}
		else
		{
			lStart = 0;
			cntEntprellen2 = 0;
		}
		
		if (!((GPIO_IN >>8) & 1))
		{
			cntEntprellen3++;
			if (cntEntprellen3 > gEntprellen)
				if (!((GPIO_IN >>8) & 1))
					lNotAus = 1;
		}
		else
		{
			lNotAus = 0;
			cntEntprellen3 = 0;
		}
		//Ende Sensoren
		
		//Daten in gemeinsamen Speicher schreiben
		*(shm+0) = 1;			// still alive
		*(shm+2) = lAnt_L;	
		lImpuls  = (unsigned char)*(shm+3);
		lVerzA   = (short int)(((char)*(shm+4) << 8) + (char)*(shm+5));
		*(shm+6) = lGegen;     
		*(shm+7) = lStart;
		*(shm+8) = lNotAus;
		lMode	 = *(shm+9);
		
		usleep(1);	
		
	}
	//printf("Ende Client %i \n",atoi(Werte[1]));
 
} //main

// Set up a memory regions to access GPIO
//
void setup_io()
{	
   /* open /dev/mem */
   if ((mem_fd = open("/dev/mem", O_RDWR|O_SYNC) ) < 0) {
      printf("can't open /dev/mem \n");
      exit(-1);
   }

   /* mmap GPIO */
   gpio_map = mmap(
      NULL,             //Any adddress in our space will do
      BLOCK_SIZE,       //Map length
      PROT_READ|PROT_WRITE,// Enable reading & writting to mapped memory
      MAP_SHARED,       //Shared with other processes
      mem_fd,           //File to map
      gpio_base         //Offset to GPIO peripheral
   );

   close(mem_fd); //No need to keep mem_fd open after mmap

   if (gpio_map == MAP_FAILED) {
      printf("mmap error %d\n", (int)gpio_map);//errno also set!
      exit(-1);
   }

   // Always use volatile pointer!
   gpio = (volatile unsigned *)gpio_map;


} // setup_io