/*#################################################################                                        
  Project: EDMA - Ultraschall Sensoren
  Author: Bastian Kramer
  Version: 3.0.0
  Date: 01.09.2018
#################################################################*/

//#################################################################
//COMPILE WITH:     gcc -o ULATRA ULTRA.c
//#################################################################

#define VERSION "4.0.2"

#define TRIGGER 		24
#define ECHO 			25
#define ECHO_2			12
#define ECHO_3			16

#include <sys/shm.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/ipc.h>

#define SHMSZ     4

// Access from ARM Running Linux

#define BCM2708_PERI_BASE        0x20000000		// Pi_2     0x3F000000
#define GPIO_BASE                (BCM2708_PERI_BASE + 0x200000) /* GPIO controller */


#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <sys/timeb.h>

#define PAGE_SIZE (4*1024)
#define BLOCK_SIZE (4*1024)

int  mem_fd;
void *gpio_map;
unsigned long int gpio_base = 0;
unsigned char gRaspi = 0;

// I/O access
volatile unsigned *gpio;


// GPIO setup macros. Always use INP_GPIO(x) before using OUT_GPIO(x) or SET_GPIO_ALT(x,y)
#define INP_GPIO(g) *(gpio+((g)/10)) &= ~(7<<(((g)%10)*3))
#define OUT_GPIO(g) *(gpio+((g)/10)) |=  (1<<(((g)%10)*3))
#define SET_GPIO_ALT(g,a) *(gpio+(((g)/10))) |= (((a)<=3?(a)+4:(a)==4?3:2)<<(((g)%10)*3))

#define GPIO_SET *(gpio+7)  // sets   bits which are 1 ignores bits which are 0
#define GPIO_CLR *(gpio+10) // clears bits which are 1 ignores bits which are 0
#define GPIO_IN *(gpio+13)

//By BK--->
#define GPIO_PULLUP *(gpio+37)	//00 = No Pullup   01 = Pull Down  10 = PullUp
#define GPIO_PULLUP_CL *(gpio+38)	//Set Clock and Clear Clock Notwendig, damit Pullup bernommen wird

void setup_io();

/**********************************************************

Steuerbyte 0:	0	Read/Write freigabe Byte
Steuerbyte 1:	99 	Programm beenden
Datenbyte 0: 
Datenbyte 1: 
Datenbyte 2:
Datenbyte 3: 	
Datenbyte 4: 	

**********************************************************/


unsigned long long int GetElapsedMicroSeconds()
{
struct timeval timer_usec; 
unsigned long long int timestamp_usec; /* timestamp in microsecond */
 
  if (!gettimeofday(&timer_usec, NULL)) {
    timestamp_usec = ((long long int) timer_usec.tv_sec) * 1000000ll + 
                        (long long int) timer_usec.tv_usec;
  }
  else {
    timestamp_usec = -1;
  }
  return timestamp_usec;
}

int main(int Anz, char* Werte[])
{
int shmid, g;
key_t key;

signed char 			*shm;
unsigned long long int 	timDistanz		= 0;
unsigned long long int 	timDistanz_2 	= 0;
unsigned long long int 	timDistanz_3 	= 0;
unsigned long long int 	timTimout 		= 0;
unsigned short int 		lDistanz 		= 0;
unsigned short int 		lDistanz_2 		= 0;
unsigned short int 		lDistanz_3 		= 0;

unsigned char lZ = 0;
unsigned char lRaus = 0;

	//Version
	if (Anz > 1)
	{
		if (Werte[1][0] == 'v')
		{
			printf("ULTRA %s\n", VERSION);
			exit(0);
		}
	}
	
	if(Anz < 2)
	{
		printf("ULTRA, es wurde keine Speicherkennung uebergeben! Client: %i\n",atoi(Werte[1]));
		return -1;
	}
	
	key = atoi(Werte[1]);
	gRaspi = atoi(Werte[2]);
	
	//Register einstellen fr versch. Raspis
	if (gRaspi < 2)
		gpio_base = 0x20000000 + 0x200000;
	else	
		gpio_base = 0x3F000000 + 0x200000;

		// shared memmory einrichten **********************************************************
		// ffnet den gemeinsamen speicher ----------------------------------------------------
    if ((shmid = shmget(key, SHMSZ, 0666)) < 0) 													// int    shmget(key_t, size_t, int);
		{
        perror("shmget");
        printf("ULTRA, Fehler beim oeffnen des shared memmory, Client: %i\n",atoi(Werte[1]));
				return -2;
    }
		// bindet den speicher ein (shmat = shm attach) ---------------------------------------
    if ((shm = shmat(shmid, 0, 0)) == (signed char *) -1) 
		{
        perror("shmat");
        printf("ULTRA, Fehler beim einbinden des shared memmory, Client: %i\n",atoi(Werte[1]));
				return -3;
    }
	
	setup_io();

	INP_GPIO(TRIGGER); // must use INP_GPIO before we can use OUT_GPIO
	OUT_GPIO(TRIGGER);
	INP_GPIO(ECHO); // must use INP_GPIO before we can use OUT_GPIO
	INP_GPIO(ECHO_2);
	INP_GPIO(ECHO_3);
	
	//Pullup einschalten	//00 = No Pullup   01 = Pull Down  10 = PullUp
	GPIO_PULLUP = 0;	//Pullup aus
	GPIO_PULLUP_CL |= (1 << TRIGGER);	//bernehmen
	GPIO_PULLUP_CL &= ~(1 << TRIGGER);	//bernehmen rcksetzen
	
	GPIO_PULLUP = 0;	//Pullup aus
	GPIO_PULLUP_CL |= (1 << ECHO);	//bernehmen
	GPIO_PULLUP_CL &= ~(1 << ECHO);	//bernehmen rcksetzen
	
	GPIO_PULLUP = 0;	//Pullup aus
	GPIO_PULLUP_CL |= (1 << ECHO_2);	//bernehmen
	GPIO_PULLUP_CL &= ~(1 << ECHO_2);	//bernehmen rcksetzen
	
	GPIO_PULLUP = 0;	//Pullup aus
	GPIO_PULLUP_CL |= (1 << ECHO_3);	//bernehmen
	GPIO_PULLUP_CL &= ~(1 << ECHO_3);	//bernehmen rcksetzen
	
	
	//printf("ULTRA Starte...\n");
	
	while(*(shm+1) != 99)
	{
		lZ = 5; 
		lDistanz = 0;
		lDistanz_2 = 0;
		lDistanz_3 = 0;
		
		while(lZ > 0)
		{
			//Trigger
			GPIO_SET = 1 << TRIGGER;
			usleep(10);
			GPIO_CLR = 1 << TRIGGER;
			
			timDistanz = 0;
			timDistanz_2 = 0;
			timDistanz_3 = 0;
			
			lRaus = 0;
			
			timTimout = GetElapsedMicroSeconds() + 50000;
			while (GetElapsedMicroSeconds() < timTimout && lRaus < 3)
			{
				//Messung starten, wenn ECHO auf 1
				if (((GPIO_IN >> ECHO) & 1) && timDistanz == 0) timDistanz = GetElapsedMicroSeconds();
				if (((GPIO_IN >> ECHO_2) & 1) && timDistanz_2 == 0) timDistanz_2 = GetElapsedMicroSeconds();
				if (((GPIO_IN >> ECHO_3) & 1) && timDistanz_3 == 0) timDistanz_3 = GetElapsedMicroSeconds();
				
				//Messung abschlieen, wenn ECHO auf 0
				if (!((GPIO_IN >> ECHO) & 1) && timDistanz > 1)
				{
					lDistanz += (GetElapsedMicroSeconds() - timDistanz) / 58;
					timDistanz = 1;
					lRaus++;
				}
				if (!((GPIO_IN >> ECHO_2) & 1) && timDistanz_2 > 1)
				{
					lDistanz_2 += (GetElapsedMicroSeconds() - timDistanz_2) / 58;
					timDistanz_2 = 1;
					lRaus++;
				}
				if (!((GPIO_IN >> ECHO_3) & 1) && timDistanz_3 > 1)
				{
					lDistanz_3 += (GetElapsedMicroSeconds() - timDistanz_3) / 58;
					timDistanz_3 = 1;
					lRaus++;
				}
			}
			
			usleep(20000);
			lZ--;
		}
		if (lRaus > 0)
		{
			if (lDistanz == 0)
				lDistanz = 255;
			else
				lDistanz /= 5;
			
			if (lDistanz_2 == 0)
				lDistanz_2 = 255;
			else
				lDistanz_2 /= 5;
			
			if (lDistanz_3 == 0)
				lDistanz_3 = 255;
			else
				lDistanz_3 /= 5;
		}
		else
		{
			lDistanz = 255;
			lDistanz_2 = 255;
			lDistanz_3 = 255;
		}
		
		//printf("Dis: %i  Dis2: %i  Dis3: %i\n", lDistanz, lDistanz_2, lDistanz_3);
		
		//Daten in gemeinsamen Speicher schreiben
		*(shm+0) = 1;				// still alive
		*(shm+2) = lDistanz;		//LOW Byte	
		*(shm+3) = lDistanz >> 8;	//HIGH Byte
		*(shm+4) = lDistanz_2;		//LOW Byte	
		*(shm+5) = lDistanz_2 >> 8;	//HIGH Byte
		*(shm+6) = lDistanz_3;		//LOW Byte	
		*(shm+7) = lDistanz_3 >> 8;	//HIGH Byte
		
	}
 
} //main

// Set up a memory regions to access GPIO
//
void setup_io()
{	
   /* open /dev/mem */
   if ((mem_fd = open("/dev/mem", O_RDWR|O_SYNC) ) < 0) {
      printf("can't open /dev/mem \n");
      exit(-1);
   }

   /* mmap GPIO */
   gpio_map = mmap(
      NULL,             //Any adddress in our space will do
      BLOCK_SIZE,       //Map length
      PROT_READ|PROT_WRITE,// Enable reading & writting to mapped memory
      MAP_SHARED,       //Shared with other processes
      mem_fd,           //File to map
      gpio_base         //Offset to GPIO peripheral
   );

   close(mem_fd); //No need to keep mem_fd open after mmap

   if (gpio_map == MAP_FAILED) {
      printf("mmap error %d\n", (int)gpio_map);//errno also set!
      exit(-1);
   }

   // Always use volatile pointer!
   gpio = (volatile unsigned *)gpio_map;


} // setup_io