#include "edma.hpp"
#include "tEdMa.hpp"
#include "tZeiten.hpp"
#include <cstdio>
#include <unistd.h>

tEdMa *edma;
tZeiten *zLoggen = new tZeiten();

int main (int Anz, char* Werte[])
{
int Taste = 0;
tZeiten *info = new tZeiten();

	//Version
	if (Anz > 1)
	{
		if (Werte[1][0] == 'v')
		{
			printf("EDMA %s\n", VERSION);
			exit(0);
		}
	}
	
	edma  = new tEdMa();
	
	while (Taste == 0)
	{
		Taste = edma->kbhit();
		if (Taste != 0) getchar();
		
		edma->ProzessControl();
		switch (edma->gHStatus)
		{
			//Wenn Automodus
			case HS_AUTO:
				switch (edma->gDrive_Mode)
				{
					case DRIVE_QUADER:				
						Drive_Quader();
					break;
					
					case DRIVE_HINHER:				
						
					break;
					
					case DRIVE_CHAOSM:			
						Drive_Chaos();
					break;
					
					case DRIVE_CHAOSO:	
						Drive_Chaos();
					break;
					
				}
				
			break;
			
			case HS_SOLAR_LADEN:
				SolarLaden();
			break;
			
			case HS_LADE_SUCH:
				StationSuchen();	
			break;
			
			
		}
		if (info->AbgelaufenSek(1))
		{
			edma->PrintStatus();
		}
		usleep(1);
		
	}
	delete edma;
	
}

void Drive_Quader()
{
//EdMa fährt ein Rechteck. Nur mit Kompass möglich.
//Dieses Rechteck wird durch 4 Kompassrichtungen vorgegeben. Jede Kante eine Kompassrichtungen

	if (edma->gSchritt == 0) edma->gSchritt = ST_FAHREN_BIS_HINDERNIS;
	
	switch(edma->gSchritt)
	{
		case ST_FAHREN_BIS_HINDERNIS:
			if (edma->FahrenBisHindernis())
				edma->gSchritt = ST_ZURUECK;
		break;
		
		case ST_ZURUECK:
			if (edma->Zurueck())
			{
				edma->NeueRichtungQuader();
				edma->gSchritt = ST_DREHEN;
			}
		break;
		
		case ST_DREHEN:
			if (edma->Drehen())
				edma->gSchritt = ST_FAHREN_BIS_HINDERNIS;
		break;
		
	}

	
	
}

void Drive_Chaos()
{
//EdMa fährt im Chaos. Drehen durch Zufallszeit. 

	if (edma->gSchritt == 0) edma->gSchritt = ST_FAHREN_BIS_HINDERNIS;	
	
	switch(edma->gSchritt)
	{
		case ST_FAHREN_BIS_HINDERNIS:
			if (edma->FahrenBisHindernis())
				edma->gSchritt = ST_ZURUECK;
		break;
		
		case ST_ZURUECK:
			if (edma->Zurueck())
			{
				edma->NeueRichtungZufall();
				edma->gSchritt = ST_DREHEN;
			}
		break;
		
		case ST_DREHEN:
			if (edma->Drehen())
				edma->gSchritt = ST_FAHREN_BIS_HINDERNIS;
		break;
		
	}
}

void SolarLaden()
{
//EdMa fährt bis zum Draht, dreht dann um und fährt ein paar Sekunden. (Mitte des Rasens?)
static tZeiten *zMitteRasen = new tZeiten();

	if (edma->gSchritt == 0) edma->gSchritt = ST_FAHREN_BIS_HINDERNIS;	
	
	switch(edma->gSchritt)
	{
		case ST_FAHREN_BIS_HINDERNIS:								
			edma->PWM(edma->gPWM_Vor, edma->gPWM_Vor, 0);			//Um das Mähwerk abzuschalten.
			if (edma->FahrenBisHindernis())
				edma->gSchritt = ST_ZURUECK;
		break;
		
		case ST_ZURUECK:
			if (edma->Zurueck())
			{
				edma->NeueRichtungZufall();
				edma->gSchritt = ST_DREHEN;
			}
		break;
		
		case ST_DREHEN:
			if (edma->Drehen(3000))
				edma->gSchritt = ST_FAHREN_BIS_MITTE;
				zMitteRasen->Reset();
		break;
		
		case ST_FAHREN_BIS_MITTE:
			if (edma->FahrenBisHindernis() || zMitteRasen->AbgelaufenSek(10))
			{
				edma->PWM(0,0,0);
			}
		break;
		
	}
}

void StationSuchen()
{
//EdMa fährt zum Draht, dreht dann etwas links oder rechts, fährt dann am Draht entlang, bis 
//der Gegenfahrsensor auslöst.
	
	if (edma->gSchritt == 0) edma->gSchritt = ST_FAHREN_BIS_HINDERNIS;	
	
	switch(edma->gSchritt)
	{
		case ST_FAHREN_BIS_HINDERNIS:								
			edma->PWM(edma->gPWM_Vor, edma->gPWM_Vor, 0);			//Um das Mähwerk abzuschalten.
			if (edma->FahrenBisHindernis())
				edma->gSchritt = ST_FAHRE_LEICHT_L;
		break;
		
/*		case ST_ZURUECK:
			if (edma->Zurueck())
			{
				edma->NeueRichtungZufall();
				edma->gSchritt = ST_DREHEN;
			}
		break;
		
		case ST_DREHEN:
			if (edma->Drehen(1500,1)) //Links drehen
			{
				edma->gSchritt = ST_FAHRE_LEICHT_R;
				sprintf(edma->gZS_Text,"leicht rechts");
			}
		break;*/
		
		case ST_FAHRE_LEICHT_L:
			edma->PWM(edma->gPWM_Dreh_Vor / (-2), edma->gPWM_Dreh_Vor, 0);		//20% weniger bei rechts
			if (edma->AntL() == 2) 
			{
				edma->gSchritt = ST_FAHRE_LEICHT_R;
				sprintf(edma->gZS_Text,"leicht rechts");
			}
			if (edma->Gegen())
			{
				sprintf(edma->gZS_Text,"gegen");
				edma->PWM(0,0,0);
				edma->gSchritt = 0;
				edma->gHStatus = HS_LADEN;
			}
		break;
		
		case ST_FAHRE_LEICHT_R:
			edma->PWM(edma->gPWM_Dreh_Vor, edma->gPWM_Dreh_Vor / (-2), 0);		//20% weniger bei rechts
			if (edma->AntL() != 2) 
			{
				edma->gSchritt = ST_FAHRE_LEICHT_L;
				sprintf(edma->gZS_Text,"leicht links");
			}
			if (edma->Gegen())
			{
				sprintf(edma->gZS_Text,"gegen");
				edma->PWM(0,0,0);
				edma->gSchritt = 0;
				edma->gHStatus = HS_LADEN;
			}
		break;
		
		case ST_ABDOCKEN:
			if (edma->Zurueck())
			{
				edma->NeueRichtungZufall();
				edma->gSchritt = ST_DREHEN;
			}
		break;
		
		case ST_ABDOCKEN_DREHEN:
			if (edma->Drehen(1500,1)) //Links drehen
			{
				edma->gSchritt = ST_ABGEDOCKT;
				sprintf(edma->gZS_Text,"abgedockt");
			}
		break;
	}
	
	
}



