/*#################################################################                                          
  Project: EDMA Main class
  Author: Bastian Kramer
  Version: 4.1.0
  Date: 04.12.2020
#################################################################*/	

//#################################################################
//COMPILE WITH:     g++ -o ./bin/edma edma.cpp
//#################################################################
#define VERSION "4.1.6"							//aktuelle Versionsnummer
#define PATH_INI "/var/www/html/edma.ini"		//Pfad zur edma.ini
#define defkey0  1000


#include "edma.hpp"
#include "tZeiten.hpp"

#include <sys/shm.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <cstdio>
#include <termios.h>
#include <cstdlib>
#include <cstring>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/stat.h>

#include <iostream>
#include <string>


class tEdMa
{
public:
	
	//Werte aus ini
	signed char 		gPWM_Vor 		= 0;		//Geschwindigkeit vorwärts
	signed char 		gPWM_Rueck 		= 0;		//Geschwindigkeit rückwärts
	signed char 		gPWM_Dreh_Vor 	= 0;		//Drehgeschwindigkeit vorwärts
	signed char 		gPWM_Dreh_Rueck	= 0;		//Drehgeschwindikeit rückwärts
	signed char 		gPWM_Komp_Korr	= 0;		//Geschwindigkeit Kompasskorrektur
	unsigned int 		gZeit_Rueck 	= 0;		//Zeit für Rückwärtsfahren nach Antenne oder Gegensensor 
	unsigned char 		gDrive_Mode 	= 0;		//Drivemode 0 = Quader  1 = Hin Her  2 = Chaos (mit Kompass)  
												//			3 = Chaos ohne Kompass   4 = Finde Draht
	
	//Variablen
	short int 			gHStatus		= 0;    	//aktueller Hauptstatus
	short int 			gZStatus		= 0;    	//aktueller Zusatzstatus
	short int 			gBatt 			= 0;		//aktuelle Batteriespannung (12 V = 1200)
	short int 			gSchritt		= 0;		//aktueller Schritt in den versch. Schrittketten
	short int 			gSchritt_old	= 0;		//um Schrittwechsel zu erkennen
	short int 			gDistanz 		= 0;		//Distanz zum nächsten Gegenstand
	short int 			gDistanzStop	= 0;		//stoppen wenn unterschritten
	short int 			gDistanzL		= 0;		//Distanz zum nächsten Gegenstand links
	short int 			gDistanzLAct	= 0;		//reagieren wenn unterschritten
	short int 			gDistanzR		= 0;		//Distanz zum nächsten Gegenstand rechts
	short int 			gDistanzRAct	= 0;		//reagieren wenn unterschritten
	unsigned short int	gDistanzActPro 	= 50;		//Minderung Motor in Prozent
	
	char 				gHS_Text[50];				//Text Hauptstatus
	char 				gZS_Text[50];				//Text Zusatzstatus
	int 				gDrehenHalb		= 0;		//Zeit für eine halbe Drehung
	
	//Funktionen
						tEdMa(void);
						~tEdMa();
	short int 			kbhit(void);					//Tastendruck
	void 				PrintStatus(void);				//Gibt aktuelle Werte auf das Terminal aus
	void 				PWM(int R, int L, int M = 255);
	void 				SendeText(char Text);
	void				ProzessControl(void);
	//char 				Ant_R(void);					//Abfragen ob Sensor ausgelöst hat			
	char 				AntL(void);						//Abfragen ob Sensor ausgelöst hat	
	char 				Gegen(void);					//Abfragen ob Sensor ausgelöst hat	
	char 				Distanz(void);					//Abfragen ob Distanz unterschritten
	signed char			DistanzL(void);					//Abfrage ob Gegenstand links im Weg
	signed char			DistanzR(void);					//Abfrage ob Gegenstand rechts im Weg
	short int			WinkelDiff(int a,int b);
	char				FahrenBisHindernis(void);
	char 				Zurueck();						//Zurückfahren für gZeit_Rueck. Antennen werden dabei überwacht
	void				NeueRichtungQuader(void);		//Setzt neue soll Kompassrichtung (eine der 4 Quaderrichtungen)
	void 				NeueRichtungZufall(void); 		//Setzt neue Kompassrichtung per Zufallszahl
	char 				Drehen(int Zeit_Winkel = 32000, char aRichtung = 0);
	unsigned int 		gMaxMaehStrom = 3000;
	
private:
						key_t key;
	char 				*shm;
	char 				*TELZeiger, *TELRueckZeiger, *PWM1Zeiger, *PWM2Zeiger, *PWM3Zeiger, *DatenInZeiger;
	char 				*Kompassdaten, *Ultradaten, *SystemZeit;
	
	//Werte aus edma.ini
	
	unsigned char 		gRaspi 			= 0;		//Verwendeter Raspi
	unsigned char 		gKompass 		= 0;		//Verwendeter Kompass    0 = HMC (0x1e)		1 = QMC  (0x0d)
	char 				gLoggen 		= 0;		//Loggen 0 = kein Loggen	1 = EdMa	2 = Kompass	
	int 				gTotmannZeit	= 0;		//Zeit in Sekunden, nach der EdMa stehen bleibt, wenn kein Antennekontakt.
	unsigned long 		gEntprellen 	= 0;		//Zeit für Entprellen der Antennen
	unsigned int 		gR16 			= 0;		//Offset für Spannungsmessung
	unsigned int 		gR17 			= 0;		//Offset für Spannungsmessung
	short int 			gBattVoll 		= 0;		//Batteriespannung Batterie voll geladen (13.8V)
	short int 			gBattLeer 		= 0;		//Batteriespannung Batterie leer. Ladestation anfahren.
	char 				gBattLaden		= 0;		//1, wenn Batterie geladen wird
	char 				gSolarladen		= 1;		//Ladestation suchen = 0, Solarladen = 1
	unsigned char 		gImpuls			= 250;		//Längenanpassung Antennenimpuls
	unsigned short 		gVerzA			= 500;		//Veroegerung Antenne 2>1 in using
	unsigned char		gAntMode		= 0;		//Antennenmodus  0= neue Drahterkennung  1= alte
	unsigned char 		gNotAus 		= 1;		//NotAus
	
	//Interne Variablen
	char 				gAnt_L 			= 0;		//Antenne links 
	char 				gAnt_R 			= 0;		//nicht in Benutzung
	char				gAntOff			= 0;		//0= Antennen aktiv, 1= Antennen deaktiviert
	char 				gLogThis 		= 0;		//Loggen für diese Klasse aktiv.
	signed char 		gPWM_L			= 0;		//PWM Motor links
	signed char 		gPWM_R			= 0;		//PWM Motor rechts
	signed char 		gPWM_M			= 0; 		//PWM Mähmotor
	unsigned int 		gStromML 		= 0;		//aktueller Strom Motor links
	unsigned int 		gStromMR		= 0;		//aktueller Strom Motor rechts
	unsigned int 		gStromMW		= 0;		//aktueller Strom Mähwerk
	signed int 			gWinkel_ist		= 0;		//aktuelle Kompassrichtung (0-360)
	signed int 			gWinkel_soll	= 0;		//soll Kompassrichtung (0-360)
	float 				gGPSLo			= 7.222;	// GPS Latitude EdMa
	float 				gGPSLa			= 53.555;	// GPS Longitude EdMa
	float 				gGPSTelLa		= 0;		// GPS Latitude Telefon
	float 				gGPSTelLo		= 0;		// GPS Longitude Telefon
	
	char 				tmp[100];					//Temporäre Variable für String
	time_t 				now;						//Uhrzeit (Systemzeit)
	struct 				tm *myTm;					//Uhrzeit (Systemzeit)
	
	//Zeiten
	tZeiten 			*zTotmann 		= new tZeiten();
	tZeiten 			*zVerbindung 	= new tZeiten();
	tZeiten 			*zBatterie 		= new tZeiten();
	tZeiten 			*zKeinAnt 		= new tZeiten();
	tZeiten 			*zLog 			= new tZeiten();
	
	//Funktionen
	void 				ReadIni(void);
	char* 				ErstelleSpeicher(int Schluessel, int Speicherbytes);
	void 				StarteThreadPWM(int Schluessel);
	void 				StarteThreadDIN(int Schluessel);
	void 				StarteThreadKompass(int Schluessel);
	void				StarteThreadULTRA(int Schluessel);
	int 				Zufallszahl(int aMin, int aMax);
	void 				Kompasskorrektur(void);
	void				Log(void);
	void 				LogPES(const char *aText);
	char				Taster_Start(void);
	char				NotAus(void);
	void 				StringField(char *aString, int aField, char *aText);
	char 				TextToByte(char *aSpeicher, char* aText);
	float 				Read_Float(char *aSpeicher);
	void				FloatToByte(char *aSpeicher, float aWert);
		
};

void tEdMa::ProzessControl(void)
{
static int lBattLeerCnt = 0;
static int lBattVollCnt = 0;
static int lHStatus_Rett = 0;
static char lFileModified[30];
static struct stat filestat;

	//ini neu einlesen, wenn geändert
	
	stat("/var/www/html/edma.ini",&filestat);
	if (strcmp(ctime(&filestat.st_mtime), lFileModified))
	{
		sprintf(lFileModified, "%s", ctime(&filestat.st_mtime)); 
		this->ReadIni();
		sprintf(this->gZS_Text, "Read ini");
	}
		
	//sämtliche Werte aktualisieren
	this->gBatt = (int)(((char)KOMP_AD_HIGH << 8) + (char)KOMP_AD_LOW);
	this->gWinkel_ist = (int)(((char)KOMP_ANG_HIGH << 8) + (char)KOMP_ANG_LOW);
	
	/*nord = TELGET_NORD;
	west = TELGET_WEST;
	ost = TELGET_OST;
	sud = TELGET_SUD;
	*/
	
	//Taste\n
	/*if (TELGET_KEY == 19 && this->gBattLaden == 0)
	{
		TELGET_KEY = 0;

		printf("Laden\n");
		this->gBattLaden = 1;
		lBattLeerCnt = 0;
		lHStatus_Rett = this->gHStatus;
			
		if (this->gSolarladen) 
		{
			//Solar laden aktivieren
			this->gHStatus = HS_SOLAR_LADEN;
		}
		else 
		{
			//Stationsladen aktivieren
			this->gHStatus = HS_LADE_SUCH;
		}
	}
	
	if (TELGET_KEY == 18 && this->gBattLaden == 1)
	{
		printf("Nicht mehr laden\n");
		lBattVollCnt = 0;
		this->gBattLaden = 0;
		this->gHStatus = lHStatus_Rett;
		this->gSchritt = ST_ZURUECK;
	}*/
	
	//Motorströme
	this->gStromML = (unsigned int)(KOMP_AD_ML_HIGH << 8) + KOMP_AD_ML_LOW;
	this->gStromMR = (unsigned int)(KOMP_AD_MR_HIGH << 8) + KOMP_AD_MR_LOW;
	this->gStromMW = (unsigned int)(KOMP_AD_M_HIGH << 8) + KOMP_AD_M_LOW;
	
	//Antennen und Gegenfahrsensor
	if (this->gAntOff) 
		this->gAnt_L = 2;
	else
		this->gAnt_L = DIN_ANT_L;
	
	this->gAnt_R = this->gAnt_L;//if (DIN_ANT_R) gAnt_R = 1;
	DIN_IMPULS   = this->gImpuls;
	DIN_VERZA_HIGH = (this->gVerzA >> 8);
	DIN_VERZA_LOW = (this->gVerzA & 0x00ff);
	DIN_MODE = this->gAntMode;
	
	//Distanzsensor
	this->gDistanz = (short int)(((char)ULTRA_HIGH << 8) + (char)ULTRA_LOW);
	if (this->gDistanz > 255 || this->gDistanzStop == 0) gDistanz = 255;
	this->gDistanzL = (short int)(((char)ULTRA_L_HIGH << 8) + (char)ULTRA_L_LOW);
	if (this->gDistanzL > 255 || this-> gDistanzLAct == 0) gDistanzL = 255;
	this->gDistanzR = (short int)(((char)ULTRA_R_HIGH << 8) + (char)ULTRA_R_LOW);
	if (this->gDistanzR > 255 || this->gDistanzRAct == 0) gDistanzR = 255;
	
	//Zeit prüfen und ggf. einstellen
	//aktuelle Uhrzeit
	time(&now);
	myTm = localtime(&now);
	
	if (SZ_JAHR != 0)
	{
		sprintf(tmp, "date -s '%i-%i-%i %i:%i'", SZ_JAHR+2000, SZ_MONAT, SZ_TAG, SZ_STUNDE, SZ_MINUTE);
		printf(tmp);
		system(tmp);
		SZ_JAHR = 0;
		sprintf(this->gZS_Text, "Sytemzeit gesetzt");
	}
	
	//Wenn NotAus ausgelöst, dann Totmann
	if (!NotAus() || this->gNotAus == 1)
	{
		this->PWM(0, 0, 0);		//Alle Motoren stopp
		this->gPWM_L = 0;
		this->gPWM_R = 0;
		this->gPWM_M = 0;
		this->gHStatus = HS_TOTMANN;
		this->gNotAus = 1;
		sprintf(this->gZS_Text, "NotAus");
	}
	//Wenn alles auf 0, dann NotAus quittieren
	if (NotAus() && TELGET_PWM_R == 0 && TELGET_PWM_L == 0 && TELGET_PWM_M == 0) 
		this->gNotAus = 0;
		
	//Totmann nur im Automodus
	if (this->gHStatus == HS_AUTO)
	{
		if (AntL() != 2 || (this->Gegen()))
		{
			this->zTotmann->Reset();	//Zeit zurücksetzen
			sprintf(this->gZS_Text, "Totmann reset");
		}
		
		if (this->zTotmann->AbgelaufenSek(this->gTotmannZeit))
		{
			//Timer abgelaufen.
			this->PWM(0, 0, 0);		//Alle Motoren stopp
			this->gHStatus = HS_TOTMANN;
			LogPES("Totmann");
			printf("Totmann\n");
			sprintf(this->gZS_Text, "Totmann");
		}
		
	}
	
	//Keine Antenne
	if (AntL() == 0 && this->gHStatus != HS_MANUEL)
	{
		if (this->zKeinAnt->AbgelaufenSek(3))
			if (this->gSchritt != ST_ZURUECK)
			{
				this->gHStatus = HS_KEINE_ANTENNE;
				sprintf(this->gZS_Text, "Keine Antenne");
			}
	}
	else
	{
		this->zKeinAnt->Reset();
	}
	//if (this->gHStatus != HS_LADEN && this->gHStatus == HS_AUTO) this->gHStatus = HS_LADE_SUCH;
	//Batteriespannung prüfen.
	//Wenn Spannung zu niedrig sofort Laden
	if(this->gBatt <= 1050 && this->gBattLaden == 0 && this->gHStatus == HS_AUTO) lBattLeerCnt = 4;
	
	if (this->zBatterie->AbgelaufenSek(30))
	{	
		if(this->gBatt <= this->gBattLeer && this->gBattLaden == 0 && this->gHStatus == HS_AUTO)
			lBattLeerCnt++;
		else
			lBattLeerCnt = 0;
		
		if(this->gBatt >= this->gBattVoll && this->gBattLaden == 1)
			lBattVollCnt++;
		else
			lBattVollCnt = 0;
		
		printf("Batt: %i V: %i L: %i\n", gBatt, lBattVollCnt, lBattLeerCnt);
		sprintf(this->gZS_Text, "Batt: %i V: %i L: %i\n", gBatt, lBattVollCnt, lBattLeerCnt);
	}
	
	if (lBattLeerCnt >= 3)
	{
		this->gBattLaden = 1;
		lBattLeerCnt = 0;
		lHStatus_Rett = this->gHStatus;
		
		if (this->gSolarladen) 
		{
			//Solar laden aktivieren
			this->gHStatus = HS_SOLAR_LADEN;
		}
		else 
		{
			//Stationsladen aktivieren
			this->gHStatus = HS_LADE_SUCH;
		}
	}
		
	if (lBattVollCnt >= 3)
	{
		lBattVollCnt = 0;
		this->gBattLaden = 0;
		this->zTotmann->Reset();	//Zeit zurücksetzen
		sprintf(this->gZS_Text, "BattVoll - Totmann reset");
		this->gHStatus = lHStatus_Rett;
		
	}
	
	
	// Statustexte
	if (this->gHStatus ==  0) sprintf(this->gHS_Text, "STOP");
	if (this->gHStatus == 10) sprintf(this->gHS_Text, "MANUELL");
	if (this->gHStatus == 20) sprintf(this->gHS_Text, "AUTO");
	if (this->gHStatus == 30) sprintf(this->gHS_Text, "TOTMANN");
	if (this->gHStatus == 40) sprintf(this->gHS_Text, "LADE SUCH");
	if (this->gHStatus == 50) sprintf(this->gHS_Text, "LADEN");
	if (this->gHStatus == 60) sprintf(this->gHS_Text, "AUFGELADEN");
	if (this->gHStatus == 70) sprintf(this->gHS_Text, "SOLAR LADEN");
	if (this->gHStatus == 80) sprintf(this->gHS_Text, "KEINE ANTENNE");
	
	// Zum Handy Daten zum Anzeigen senden
	TELSET_PWM_R 			= PWM_R;							//PWM rechter Motor
	TELSET_PWM_L 			= PWM_L;							//PWM linker Motor
	TELSET_PWM_M 			= PWM_M;							//PWM Mähmotor
	TELSET_ANT_R 			= 0;//DIN_IMPULS;						// Antenne links
	TELSET_ANT_L 			= this->AntL();						// Antenne rechts
	TELSET_GEGEN			= this->Gegen();					// Gegenfahrsensor
	TELSET_KOMP_ANG_LOW 	= KOMP_ANG_LOW;						//Winkel lowByte
	TELSET_KOMP_ANG_HIGH 	= KOMP_ANG_HIGH;					//Winkel highByte
	TELSET_KOMP_AD_LOW		= KOMP_AD_LOW;						//Betterie lowByte
	TELSET_KOMP_AD_HIGH		= KOMP_AD_HIGH;						//Baterrie highByte
	TELSET_KOMP_AD_M_LOW 	= KOMP_AD_M_LOW;					//Mähmotor lowByte
	TELSET_KOMP_AD_M_HIGH	= KOMP_AD_M_HIGH;					//Mähmotro highByte
	TELSET_KOMP_AD_ML_LOW	= KOMP_AD_ML_LOW;					//Motor links lowByte
	TELSET_KOMP_AD_ML_HIGH	= KOMP_AD_ML_HIGH;					//Motor links highByte
	TELSET_KOMP_AD_MR_LOW 	= KOMP_AD_MR_LOW;					//Motor rechts lowByte
	TELSET_KOMP_AD_MR_HIGH	= KOMP_AD_MR_HIGH;					//Motor rechts highByte
	TELSET_HSTATUS_LOW      = this->gHStatus & 0x00ff;			//Status lowByte
	TELSET_HSTATUS_HIGH		= this->gHStatus >> 8;				//Status highByte
	TELSET_KOMP_SOLL_LOW 	= this->gWinkel_soll & 0x00ff;
	TELSET_KOMP_SOLL_HIGH   = this->gWinkel_soll >> 8;
	TELSET_HS_TEXT			= TextToByte(&TELSET_HS_TEXT, this->gHS_Text);
	TELSET_ZS_TEXT			= TextToByte(&TELSET_ZS_TEXT, this->gZS_Text);
	FloatToByte(&TELSET_GPS_LO, this->gGPSLo);
	FloatToByte(&TELSET_GPS_LA, this->gGPSLa);
	TELSET_ULTRA			= (unsigned char) this->gDistanz;
	TELSET_ULTRA_L			= (unsigned char) this->gDistanzL;
	TELSET_ULTRA_R			= (unsigned char) this->gDistanzR;
	
	// Daten vom Telefon
	this->gGPSTelLo = Read_Float(&TELGET_GPS_LO);
	this->gGPSTelLa = Read_Float(&TELGET_GPS_LA);
	
	KOMP_LOGGEN 			= gLoggen;							//Debugger
	
	//Start Tasten
	if (Taster_Start())
	{
		if (TELGET_STR_CTL == 1)
			TELGET_STR_CTL = 2;			//Manuell
		else
		{	if (this->gAnt_L == 2)		//Nur wenn innerhalb der Schleife
				this->gNotAus = 0;		//NotAus quittieren
				TELGET_STR_CTL = 1;		//Auto
				TELGET_PWM_M = 100;		//Mähmotor ein
		}
	}
	
	//Status
	switch(this->gHStatus)
	{
		case HS_STOP:
		
			this->PWM(0, 0, 0);												//Alle Motoren stopp
			this->gSchritt = 0;												//Schritt wieder auf Anfang
			this->zTotmann->Reset();
			
			switch(TELGET_STR_CTL)
			{
				case 1:	
					this->zTotmann->Trigger();			//Totmman neustarten, damit er nicht gleich stehen bleibt.
					this->gHStatus = HS_AUTO;
				break;
				
				case 2: 
					this->gHStatus = HS_MANUEL;
				break;
			}
			
		break;
		
		case HS_MANUEL:
		
			this->PWM(TELGET_PWM_R, TELGET_PWM_L, TELGET_PWM_M);			//PWM vom Handy übernehmen.
			
			if (this->zVerbindung->AbgelaufenMS(500))
			{
				if (TELGET_STR_CTL != 2)									//Wenn nicht 2, dann hat das Handy nicht auf 2 gestellt. Verbindung tot?
				{
					this->gHStatus = HS_STOP;
				}
				TELGET_STR_CTL = 0;											//Wird vom Handy wieder auf 2 gesetzt.
			}
			this->gSchritt = 0;
			this->zTotmann->Reset();
			this->gWinkel_soll = this->gWinkel_ist;
			
		break;
		
		case HS_AUTO:
			
			this->PWM(gPWM_R, gPWM_L, TELGET_PWM_M);
			
			if (TELGET_STR_CTL != 1)										// Vom Handy auf 2 gesetzt?
				this->gHStatus = 0;
				
		break;
		
		case HS_LADE_SUCH:
			if (TELGET_STR_CTL != 1)										// Vom Handy auf 2 gesetzt?
				this->gHStatus = 0;
		break;
		
		case HS_LADEN:
			if (this->gSchritt == ST_ABGEDOCKT)
				this->gHStatus = lHStatus_Rett;
		break;
		
		case HS_SOLAR_LADEN:
		
			if (TELGET_STR_CTL == 2)										// Vom Handy auf 2 gesetzt?
				this->gHStatus = HS_STOP;
		break;
		
		case HS_TOTMANN:
			//Totmann      ->  Warten bis vom Handy manuell kommt
			PWM(0,0,0);
			if (TELGET_STR_CTL == 2)
			{
				this->zTotmann->Reset();
				this->gHStatus = HS_MANUEL;
			}
			this->gSchritt = 0;
		break;
		
		case HS_KEINE_ANTENNE:
		
			PWM(0,0,0);
			if (AntL() != 0) this->gHStatus = HS_STOP;
			this->gSchritt = 0;
			
			if (TELGET_STR_CTL == 2) this->gHStatus = HS_MANUEL;
		break;
			
	}
	
	if (this->zLog->AbgelaufenSek(15)) this->Log();
	
}

char tEdMa::Drehen(int aZeit_Winkel, char aRichtung)
{
//aRichtung = 1 -> links drehen
static tZeiten *zTimeout = new tZeiten();
static int lTimeout = 0;
static char lRunning = 0;
char lResult = 0;
	
	//First
	if (this->gSchritt != this->gSchritt_old)
	{
		this->gSchritt_old = this->gSchritt;
		
		if (this->gDrive_Mode == DRIVE_CHAOSO)
		{
			zTimeout->Reset();
			if (aZeit_Winkel == 32000)
				lTimeout = this->Zufallszahl(this->gDrehenHalb / 5, this->gDrehenHalb);
			else
				lTimeout = aZeit_Winkel;
			zTimeout->AbgelaufenMS(lTimeout);
			sprintf(this->gZS_Text,"Drehen Zufall (%i)", lTimeout);
			LogPES(this->gZS_Text);
		}
		
		if (this->gDrive_Mode == DRIVE_CHAOSM)
		{
			if (aZeit_Winkel == 32000)
				gWinkel_soll = gWinkel_soll + this->Zufallszahl(30,60);
			else
				gWinkel_soll = gWinkel_soll + aZeit_Winkel;
			if (gWinkel_soll > 360) gWinkel_soll -= 360;
			if (gWinkel_soll < 0) gWinkel_soll += 360;
			sprintf(this->gZS_Text,"Drehen Zufall winkel (%i)", gWinkel_soll);
			LogPES(this->gZS_Text);
		}
	}
	
	if (this->gDrive_Mode == DRIVE_CHAOSM)
	{
		if (this->WinkelDiff(gWinkel_ist, gWinkel_soll) > 0)
		{
			if (abs(this->WinkelDiff(gWinkel_ist, gWinkel_soll)) < 30)
			{
				//Langsamer
				this->gPWM_L = this->gPWM_Dreh_Vor;// / 1.2;
				this->gPWM_R = this->gPWM_Dreh_Rueck;// / 1.2;
			}
			else
			{
				this->gPWM_L = this->gPWM_Dreh_Vor;
				this->gPWM_R = this->gPWM_Dreh_Rueck;
			}
			if (abs(this->WinkelDiff(gWinkel_ist, gWinkel_soll)) < 10) 
			{
				lResult = 1;
				this->PWM(0, 0);
				LogPES("Drehen ende l");
			}
			else
				this->PWM(gPWM_R, gPWM_L);
		}
		else
		{
			if (abs(this->WinkelDiff(gWinkel_ist, gWinkel_soll)) < 30)
			{
				this->gPWM_L = this->gPWM_Dreh_Rueck;// / 1.2;
				this->gPWM_R = this->gPWM_Dreh_Vor;// / 1.2;
			}
			else
			{
				this->gPWM_L = this->gPWM_Dreh_Rueck;
				this->gPWM_R = this->gPWM_Dreh_Vor;
			}
			if (abs(this->WinkelDiff(gWinkel_ist, gWinkel_soll)) < 10) 
			{
				lResult = 1;
				this->PWM(0, 0);
				LogPES("Drehen ende s");
			}
			else
				this->PWM(gPWM_R, gPWM_L);
		}
		
	}
	else
	{
		if (lTimeout % 2 == 0 || aRichtung == 1)
		{
			this->PWM(this->gPWM_Dreh_Rueck, this->gPWM_Dreh_Vor);
		}
		else
		{
			this->PWM(this->gPWM_Dreh_Vor, this->gPWM_Dreh_Rueck);
		}
		
	}
	
	if (zTimeout->AbgelaufenMS(lTimeout))		//Abbrechen, wenn Drehzeit um
	{
		zTimeout->Reset();
		this->PWM(0,0);
		lRunning = 0;
		lResult = 1;
		sprintf(this->gZS_Text,"Drehen Ende");
		LogPES(this->gZS_Text);
	}
	
	return lResult;
	
}

char tEdMa::Zurueck()
{
//Zurückfahren für die eingestellte Zeit gZeit_Rueck.
static tZeiten *zZurueck = new tZeiten();
static tZeiten *zTimeout = new tZeiten();
static tZeiten *zMin 	 = new tZeiten();
static tZeiten *zWarten   = new tZeiten();
static char lStatus = 0;
char lResult = 0;
int lWarten = 1500;

	//First
	if (this->gSchritt != this->gSchritt_old)
	{
		this->gSchritt_old = this->gSchritt;
		sprintf(this->gZS_Text,"Zurück (%i)", gZeit_Rueck);
		LogPES(this->gZS_Text);
		zTimeout->Reset();
		zWarten->Reset();
		lStatus = 0;
	}
	
	if (zWarten->AbgelaufenMS(lWarten) && lStatus == 0)
	{
		this->PWM(this->gPWM_Rueck, this->gPWM_Rueck);
		lStatus = 1;
		zZurueck->Reset();
		zMin->Reset();
		LogPES("Pause abgelaufen");
	}
	
	if (lStatus == 1)
	{
		if (this->AntL() == 2)
		{
			if (zZurueck->AbgelaufenMS(gZeit_Rueck))
			{
				printf("Zurueck fertig\n");
				this->PWM(0, 0);
				zZurueck->Reset();
				zTimeout->Reset();
				zMin->Reset();
				zWarten->Reset();
				lResult = 1;
				lStatus = 0;
				sprintf(this->gZS_Text,"Zurück Ende");
				LogPES(this->gZS_Text);
			}
		}
		
		if (this->Gegen() || AntL() != 2)
		{
			if (zMin->AbgelaufenSek(gZeit_Rueck))
			{
				printf("Zurueck fertig gegen oder Antenne\n");
				this->PWM(0, 0);
				zZurueck->Reset();
				zTimeout->Reset();
				zMin->Reset();
				zWarten->Reset();
				lResult = 1;
				sprintf(this->gZS_Text,"Zurück Ende gegen");
				LogPES(this->gZS_Text);
			}
		}
	}
	
	//Wenn die gesamte Aktion zu lange dauert STOP
	if (zTimeout->AbgelaufenMS(gZeit_Rueck * 10))
	{
		this->PWM(0, 0, 0);
		this->gHStatus = HS_TOTMANN;
		LogPES("Zurueck ende Totmann");
	}
	
	return lResult;
}

char tEdMa::FahrenBisHindernis()
{
//Fährt bis Hindernis.
char lResult = 0;

	//First
	if (this->gSchritt != this->gSchritt_old)
	{
		this->gSchritt_old = this->gSchritt;
		LogPES("Fahren bis Hindernis first");
	}
	
	if ((AntL() != 2) || (this->Gegen()))
	{
		this->PWM(0,0);
		lResult = 1;
		sprintf(this->gZS_Text,"Fahren bis Hindernis ENDE -> Ant %i -> Gegen %i", AntL(), this->Gegen());
		LogPES(this->gZS_Text);
	}
	else
	{
		if (this->gDrive_Mode == DRIVE_CHAOSO)
			this->PWM(this->gPWM_Vor, this->gPWM_Vor);
		else
			this->Kompasskorrektur();
		
		lResult = 0;
		sprintf(this->gZS_Text,"Fahren bis Hindernis");
	}
	
	return lResult;
	
}

short int tEdMa::WinkelDiff(int a,int b)
{    
	int diff;
	diff = a-b;
    if(diff > 180)
    {
        return ((diff + 180) % 360 ) - 180;
    }
    else if(diff < -180)
    {
        return ((diff - 180) % 360 ) + 180;
    }
    else
    {
        return diff % 360;
    }
};

void tEdMa::NeueRichtungQuader()
{
//Setzt neue Sollrichtung aus einem der 4 vorgegebenen Winkel
static char lWinkel = 0;

	if (lWinkel == 0) gWinkel_soll = TELGET_NORD;
	if (lWinkel == 1) gWinkel_soll = TELGET_OST;
	if (lWinkel == 2) gWinkel_soll = TELGET_SUD;
	if (lWinkel == 3) gWinkel_soll = TELGET_WEST;
	lWinkel++;
	if (lWinkel > 3) lWinkel = 0;
}

void tEdMa::NeueRichtungZufall()
{ 
//Errechnet einen neuen Winkel in entgegengesetzter Richtung der auslösenden Antenne

	gWinkel_ist += this->Zufallszahl(20, 80);
	if (gWinkel_ist > 360) gWinkel_ist -= 360;
	gWinkel_soll = gWinkel_ist;
	
}

char Drehen_Quader()
{
//Dreht bis zum nächsten Winkel der 4 Winkel
	
	return 0;
	
}

int tEdMa::Zufallszahl(int aMin, int aMax)
{
int i;
int zahl = 0;

  srand ((unsigned) time(NULL));
  zahl = (aMin + (rand() % aMax));
  
  return zahl;
 
}

tEdMa::tEdMa(void)
{
	printf("Konstruktor\n");
	
	//Versionen abrufen
	system("rm /var/www/html/versions");
	system("/root/bin/edma v >> /var/www/html/versions");
	system("/root/bin/DIN v >> /var/www/html/versions");
	system("/root/bin/PWM v >> /var/www/html/versions");
	system("/root/bin/KOMPASS v >> /var/www/html/versions");
	system("/root/bin/ULTRA v >> /var/www/html/versions");
	system("/root/bin/UPDATE v >> /var/www/html/versions");
	//system("rm /var/www/html/log/*");
	
	//Ini Datei einlesen
	this->ReadIni();
	
	//shared memory initialisieren
	//Log("Memory...");
	TELZeiger = this->ErstelleSpeicher(10,21);		//Speicherbereich 10 für Handy
	TELGET_STR_CTL 		= 0;	// Steuer (Contro) 0= Aus ; 1-Automatik ; 2-mit Handy (manuell) ; 99-Prog beenden
	TELGET_PWM_R 		= 0;	// Motor links PWMwert -100 bis +100
	TELGET_PWM_L 		= 0;	// Motor rechts PWMwert -100 bis +100
	TELGET_PWM_M 		= 0;	// Mähmotor PWMwert 0 bis +100
	TELGET_KEY 			= 0;	//Tasten vom Handy
	TELGET_NORD_HIGH	= 0;	//high Byte Vorgabewinkel für Nord
	TELGET_NORD_LOW 	= 0;	//low Byte Vorgabewinkel für Nord
	TELGET_WEST_HIGH 	= 0;	//high Byte Vorgabewinkel für west
	TELGET_WEST_LOW 	= 0;	//low Byte Vorgabewinkel für west
	TELGET_SUD_HIGH 	= 0;	//high Byte Vorgabewinkel für süd
	TELGET_SUD_LOW 		= 0;	//low Byte Vorgabewinkel für süd
	TELGET_OST_HIGH 	= 0;	//high Byte Vorgabewinkel für ost
	TELGET_OST_LOW 		= 0;	//low Byte Vorgabewinkel für ost
	TELGET_GPS_LO		= 0;	//4 Bytes
	TELGET_GPS_LA		= 0;	//4 Bytes
	
	TELRueckZeiger = this->ErstelleSpeicher(11,111);		//Speicherbereich 11 für Handy Daten zum Handy mit 3 Bytes shared memory
	TELSET_PWM_R 			= 0;	//PWM links Wert zum Handy melden
	TELSET_PWM_L 			= 0;	//PWM rechts Wert zum Handy melden
	TELSET_PWM_M 			= 0;	//PWM Mähwerk Wert zum Handy melden
	TELSET_ANT_L 			= 0;	//Antenne links
	TELSET_ANT_R 			= 0;	//Antenne rechts
	TELSET_GEGEN 			= 0;	//Gegenfahrsensor
	TELSET_KOMP_ANG_LOW 	= 0;	//Winkel lowByte
	TELSET_KOMP_ANG_HIGH	= 0;	//Winkel highByte
	TELSET_KOMP_AD_LOW		= 0;	//Batteriespannung lowByte
	TELSET_KOMP_AD_HIGH		= 0;	//Batteriesapnnung highByte
	TELSET_KOMP_AD_M_LOW 	= 0;	//Motorstrom Mähmotor lowByte
	TELSET_KOMP_AD_M_HIGH	= 0;	//Motorstrom Mähmotor highByte
	TELSET_KOMP_AD_ML_LOW	= 0;	//Motorstrom Motor links lowByte
	TELSET_KOMP_AD_ML_HIGH	= 0;	//Motorstrom Motor links highByte
	TELSET_KOMP_AD_MR_LOW 	= 0;	//Motorstrom Motor rechts lowByte
	TELSET_KOMP_AD_MR_HIGH	= 0;	//Motorstrom Motor rechts highByte
	TELSET_HSTATUS_LOW		= 0;	//HStatus lowByte
	TELSET_HSTATUS_HIGH		= 0;	//HStatus highByte
	TELSET_KOMP_SOLL_LOW	= 0;	//Winkel soll lowByte
	TELSET_KOMP_SOLL_HIGH	= 0;	//Winkel soll low
	TELSET_HS_TEXT			= 0;
	TELSET_ZS_TEXT			= 0;
	TELSET_GPS_LO			= 0;	
	TELSET_GPS_LA			= 0;
	TELSET_ULTRA			= 0;	//Distanz Mitte in cm
	TELSET_ULTRA_L			= 0;	//Distanz Links in cm
	TELSET_ULTRA_R			= 0;	//Distanz Rechts in cm
	
	//Log("...PWM1");
	PWM1Zeiger = this->ErstelleSpeicher(1,3);		//Speicherbereich 1 für PWM1 Fahrmotor links mit 3 Bytes shared memory
	RAMPE_R = 0;
	PWM_R = 0;
	StarteThreadPWM(1);

	//Log("...PWM2");
	PWM2Zeiger = this->ErstelleSpeicher(2,3);		//Speicherbereich 2 für PWM2 mit 3 Bytes shared memory
	RAMPE_L = 0;
	PWM_L = 0;
	StarteThreadPWM(2); 

	//Log("...PWM3");
	PWM3Zeiger = this->ErstelleSpeicher(3,3);		//Speicherbereich 3 für PWM3 Mähwerk mit 3 Bytes shared memory
	RAMPE_M = 0;
	PWM_M = 0;
	StarteThreadPWM(3);

	//Log("...DIN");
	DatenInZeiger = this->ErstelleSpeicher(5,11);		//Speicherbereich 5 für Daten In mit 10 Bytes shared memory
	DIN_STR_RW  	= 0;	// Steuerbyte read write 
	DIN_STR_PRG 	= 0;	// Steuerbyte Prog beenden
	DIN_ANT_L 		= 0;	// Antenne links
	DIN_IMPULS 		= 0;	// Antenne Impulslänge
	DIN_VERZA_HIGH  = 0;	// Antenne Verzögerung high
	DIN_VERZA_LOW	= 0;	// Antenne Verzögerung low
	DIN_GEGEN 		= 0;	// Gegenfahrsensor
	DIN_START		= 0;	// Startknopf (Automatik starten ohne App)
	DIN_NOTAUS		= 0;	// NotAus 
	DIN_MODE 		= 0;	// Antennen Modus 0 = neue Drahterkennung  1 = alte Drahterkennung
	
	StarteThreadDIN(5);
	
	//Log("...KMPSS");
	Kompassdaten = this->ErstelleSpeicher(6,13);		//Speicherbereich 6 für Kompass mit 4 Bytes shared memory
	KOMP_STR_RW 	= 0;	// Steuerbyte read write 
	KOMP_STR_PRG 	= 0;	// Steuerbyte Prog beenden
	KOMP_ANG_LOW 	= 0;	// Winkel lowByte
	KOMP_ANG_HIGH 	= 0;	// Winkel high Byte
	KOMP_AD_LOW 	= 0;	// Batteriespannung lowByte
	KOMP_AD_HIGH	= 0;	// Batteriespannung highByte
	KOMP_AD_M_LOW 	= 0; 	// Strom Mähmotor lowByte
	KOMP_AD_M_HIGH	= 0;	// Strom Mähmotor highByte
	KOMP_AD_ML_LOW	= 0;	// Strom Motor links lowByte
	KOMP_AD_ML_HIGH = 0;	// Strom Motor links highByte
	KOMP_AD_MR_LOW  = 0;	// Strom Motor rechts lowByte
	KOMP_AD_MR_HIGH = 0;	// Strom Motor links highByte
	KOMP_LOGGEN	    = 0;	// Debugger für Kompass
	StarteThreadKompass(6);

	Ultradaten 	= this->ErstelleSpeicher(7,8);		//Speicherbereich 7 für Daten In mit 4 Bytes shared memory
	ULTRA_STR_RW  	= 0;	// Steuerbyte read write 
	ULTRA_STR_PRG 	= 0;	// Steuerbyte Prog beenden
	ULTRA_LOW 		= 0;	// Abstand LowByte
	ULTRA_HIGH 		= 0;	// Abstand HighByte
	ULTRA_L_LOW 	= 0;	// Abstand2 LowByte
	ULTRA_L_HIGH	= 0;	// Abstand2 HighByte
	ULTRA_R_LOW 	= 0;	// Abstand3 LowByte
	ULTRA_R_HIGH	= 0;	// Abstand3 HighByte
	
	if (this->gDistanzStop > 0 || this->gDistanzLAct > 0 || this->gDistanzRAct > 0)
		StarteThreadULTRA(7);
	
	//Log("...TIM\n");
	SystemZeit = this->ErstelleSpeicher(8,5);		//Speicherbereich 6 für Kompass mit 4 Bytes shared memory
	SZ_JAHR 		= 0;
	SZ_MONAT		= 0;
	SZ_TAG			= 0;
	SZ_STUNDE		= 0;
	SZ_MINUTE		= 0;
	
	//Updateüberwachung
	system("/root/bin/UPDATE &");
	
	//Totmann setzen
	if (gTotmannZeit <= 0) gTotmannZeit = 30;
	zTotmann->AbgelaufenSek(gTotmannZeit);
	
	//HStatus
	gHStatus = HS_STOP;
	
}

tEdMa::~tEdMa()
{
	printf("Destruktor\n");
	//Log("Ende\n");
	PWM_R = 0;
	PWM_L = 0;
	PWM_M = 0;
	
	TELSET_PWM_R 			= PWM_R;							//PWM rechter Motor
	TELSET_PWM_L 			= PWM_L;							//PWM linker Motor
	TELSET_PWM_M 			= PWM_M;							//PWM Mähmotor
	TELSET_ANT_R 			= 0;								// Antenne links
	TELSET_ANT_L 			= 0;						// Antenne rechts
	TELSET_GEGEN			= 0;					// Gegenfahrsensor
	TELSET_KOMP_ANG_LOW 	= 0;						//Winkel lowByte
	TELSET_KOMP_ANG_HIGH 	= 0;					//Winkel highByte
	TELSET_KOMP_AD_LOW		= 0;						//Betterie lowByte
	TELSET_KOMP_AD_HIGH		= 0;						//Baterrie highByte
	TELSET_KOMP_AD_M_LOW 	= 0;					//Mähmotor lowByte
	TELSET_KOMP_AD_M_HIGH	= 0;					//Mähmotro highByte
	TELSET_KOMP_AD_ML_LOW	= 0;					//Motor links lowByte
	TELSET_KOMP_AD_ML_HIGH	= 0;					//Motor links highByte
	TELSET_KOMP_AD_MR_LOW 	= 0;					//Motor rechts lowByte
	TELSET_KOMP_AD_MR_HIGH	= 0;					//Motor rechts highByte
	TELSET_HSTATUS_LOW      = 0;			//Status lowByte
	TELSET_HSTATUS_HIGH		= 0;				//Status highByte
	TELSET_KOMP_SOLL_LOW 	= 0;
	TELSET_KOMP_SOLL_HIGH   = 0;
	sprintf(this->gHS_Text, "...");
	sprintf(this->gZS_Text, "Prozess-Ende");
	TELSET_HS_TEXT			= TextToByte(&TELSET_HS_TEXT, this->gHS_Text);
	TELSET_ZS_TEXT			= TextToByte(&TELSET_ZS_TEXT, this->gZS_Text);
	
	system("killall GPS");
	//system("killall UPDATE");
	
	RAMPE_R = 99;		//PWM 1 beenden
	//sleep(1);
	//Log("Ende 1   %\n", RAMPE_R);

	RAMPE_L = 99;		//PWM 2 beenden
	//sleep(1);
	//Log("Ende 2   %\n", RAMPE_L);

	RAMPE_M = 99;		//PWM 3 beenden
	//sleep(1);
	//Log("Ende 3   %\n", *(PWM3Zeiger +1));

	DIN_STR_PRG = 99;		//Daten In beenden
	//sleep(1);
	//Log("Ende DIN   %\n", *(DatenInZeiger +1));

	KOMP_STR_PRG = 99;		//Kompass beenden
	//sleep(1);
	//Log("Ende Kompass   %\n", *(Kompassdaten +1));

	ULTRA_STR_PRG = 99;		//Kompass beenden
	//sleep(1);
	//Log("Ende Kompass   %\n", *(Kompassdaten +1));
	
	shmdt(PWM1Zeiger) == 0;


	shmdt(PWM2Zeiger) == 0;

		
	shmdt(PWM3Zeiger) == 0;

		
	shmdt(DatenInZeiger) == 0;
	

	shmdt(Kompassdaten) == 0;


	shmdt(TELZeiger) == 0;
	
	
	shmdt(Ultradaten) == 0;
	

}

short int tEdMa::kbhit(void)
{
  struct termios oldt, newt;
  int ch;
  int oldf;
 
  //Attribute holen
  tcgetattr(STDIN_FILENO, &oldt);
  newt = oldt;
  newt.c_lflag &= ~(ICANON | ECHO); //Echo und zeilenweise... auschalten
  //neue Attribute setzen
  tcsetattr(STDIN_FILENO, TCSANOW, &newt);
  oldf = fcntl(STDIN_FILENO, F_GETFL, 0);
  fcntl(STDIN_FILENO, F_SETFL, oldf | O_NONBLOCK); //blockieren abschalten

  ch = getchar();  //Zeichen holen
 
  //alte Attribute setzen
  tcsetattr(STDIN_FILENO, TCSANOW, &oldt);
  fcntl(STDIN_FILENO, F_SETFL, oldf);
 
  if(ch != EOF)
  {
    ungetc(ch, stdin);
    return ch;// 1;
  }
 
  return 0;
}

char* tEdMa::ErstelleSpeicher(int Schluessel, int Speicherbytes)
{
 int shmid;
 
	this->key = defkey0 + Schluessel;
	if ((shmid = shmget(key, Speicherbytes, IPC_CREAT | 0666)) < 0) 
	{
        //Log("ESS-Fehler 1\n");
    }
    shm = (char*) shmat(shmid, 0, 0);
	return shm;
}

void tEdMa::StarteThreadPWM(int Schluessel)
{
char vari[40];
	key = defkey0 + Schluessel;
	sprintf(vari, "/root/bin/PWM %i %i &",key, gRaspi);
	system(vari);
	//Log(vari);
}

void tEdMa::StarteThreadDIN(int Schluessel)
{
char vari[40];
	key = defkey0 + Schluessel;
	sprintf(vari, "/root/bin/DIN %i %i %u &",key, gRaspi, gEntprellen);  // & bedeutet mach dann weiter und warte nicht
	system(vari);
	//Log(vari);
}

void tEdMa::StarteThreadKompass(int Schluessel)
{
char vari[40];
	key = defkey0 + Schluessel;
	sprintf(vari, "/root/bin/KOMPASS %i %i %u %u &",key, gKompass, gR16, gR17);  // & bedeutet mach dann weiter und warte nicht
	system(vari);
	//Log(vari);
}

void tEdMa::StarteThreadULTRA(int Schluessel)
{
char vari[40];
	printf("Starte Ultra...\n");
	key = defkey0 + Schluessel;
	sprintf(vari, "/root/bin/ULTRA %i %i &",key, gRaspi);  // & bedeutet mach dann weiter und warte nicht
	system(vari);
	//Log(vari);
}

void tEdMa::StringField(char *aString, int aField, char *aText)
{
int n = 0;
int i = 0;
char *zeiger;

	aText[i] = '\0';
	while(aString[n] != '\0')
	{
		if (aString[n] == ';') aField--;
		if (aField == 1 && aString[n] != ';')
		{
			aText[i] = aString[n];
			i++;
			aText[i] = '\0';
		}
		n++;
	}
}

void tEdMa::ReadIni()
{
FILE *datei;
char tmp[100], tmp1[100], tmp2[100];				//Temporär für Text
float tmpF 					= 0;	//Tmeporär für Batteriespannung

	printf("Readini\n");
	if (datei = fopen(PATH_INI, "r")){
		
		//Log("Paramter -> Wert\n");
		while (fgets(tmp2, 100, datei) != NULL)
		{
			this->StringField(tmp2, 1, tmp);
			this->StringField(tmp2, 2, tmp1);
			
			if (strcmp(tmp, "Drive_Mode") == 0)
				this->gDrive_Mode= atoi(tmp1);
				
			if (strcmp(tmp, "PWM_Komp_Korr") == 0)
				this->gPWM_Komp_Korr= atoi(tmp1);

			if (strcmp(tmp, "PWM_Vor") == 0)
				this->gPWM_Vor= atoi(tmp1);
			
			if (strcmp(tmp, "PWM_Rueck") == 0)
				this->gPWM_Rueck= atoi(tmp1);

			if (strcmp(tmp, "PWM_Dreh_Rueck") == 0)
				this->gPWM_Dreh_Rueck= atoi(tmp1);

			if (strcmp(tmp, "PWM_Dreh_Vor") == 0)
				this->gPWM_Dreh_Vor= atoi(tmp1);

			if (strcmp(tmp, "Zeit_Rueck") == 0)
				this->gZeit_Rueck= atoi(tmp1);
			
			if (strcmp(tmp, "Raspi") == 0)
				this->gRaspi = atoi(tmp1);
			
			if (strcmp(tmp, "Kompass") == 0)			//0 = HMC (0x1e)		1 = QMC  (0x0d)
				this->gKompass = atoi(tmp1);
			
			if (strcmp(tmp, "BattVoll") == 0)
			{
				tmpF = atof(tmp1);
				this->gBattVoll = tmpF * 100;
			}
				
			if (strcmp(tmp, "BattLeer") == 0)
			{
				tmpF = atof(tmp1);
				this->gBattLeer = tmpF * 100;
			}
			
			if (strcmp(tmp, "Solarladen") == 0)
				this->gSolarladen = atoi(tmp1);
			
			if (strcmp(tmp, "Totmann") == 0)
				this->gTotmannZeit = atoi(tmp1);
			//if (gTotmannZeit < 30) gTotmannZeit = 30;
			
			if (strcmp(tmp, "Loggen") == 0)
			{
				this->gLoggen = atoi(tmp1);
				if (this->gLoggen <= 0)
					system("rm /var/www/html/log/*");
			}
			
			
			if (strcmp(tmp, "Entprellen") == 0)
				this->gEntprellen = atoi(tmp1);
			
			if (strcmp(tmp, "R16") == 0)
				this->gR16 = atoi(tmp1);
			
			if (strcmp(tmp, "R17") == 0)
				this->gR17 = atoi(tmp1);
			
			if (strcmp(tmp, "DistanzStop") == 0)
				this->gDistanzStop = atoi(tmp1);
			
			if (strcmp(tmp, "DistanzLinks") == 0)
				this->gDistanzLAct = atoi(tmp1);
			
			if (strcmp(tmp, "DistanzRechts") == 0)
				this->gDistanzRAct = atoi(tmp1);
			
			if (strcmp(tmp, "DistanzAusweichen") == 0)
				this->gDistanzActPro = atoi(tmp1);
			if (this->gDistanzActPro > 100) this->gDistanzActPro = 100;
			if (this->gDistanzActPro < 0) this->gDistanzActPro = 0;
			
			if (strcmp(tmp, "HalbeDrehung") == 0)
				this->gDrehenHalb = atoi(tmp1);
			
			if (strcmp(tmp, "AntImp") == 0)
				this->gImpuls = atoi(tmp1);
			
			if (strcmp(tmp, "AntVerz") == 0)
				this->gVerzA = atoi(tmp1);
			
			if (strcmp(tmp, "AntMode") == 0)
				this->gAntMode = atoi(tmp1);
			
			if (strcmp(tmp, "AntOff") == 0)
				this->gAntOff = atoi(tmp1);
			
			if (strcmp(tmp, "MaxMaehStrom") == 0)
				this->gMaxMaehStrom = atoi(tmp1) * 100;
		}
		
		fclose(datei);
	}	
}

void tEdMa::PWM(int aR, int aL, int aM)
{
static signed char lRed_pwm_l = 0;
static signed char lRed_pwm_r = 0;
static tZeiten *lRed_Interval = new tZeiten();
static tZeiten *lMaewerk = new tZeiten();

	if (this->Gegen() == 1) 
	{
		RAMPE_L = 0;	//Bei Gegen sofort stoppen. 
		RAMPE_R = 0;	
	}
	else
	{
		RAMPE_L = 2;
		RAMPE_R = 2;
	}
	
	this->gPWM_L = aL;
	this->gPWM_R = aR;
	if (aM != 255)
		this->gPWM_M = aM;	
	
	
	if (this->gHStatus == HS_MANUEL)
	{
		if (this->Gegen() && (gPWM_L > 0 || gPWM_R > 0)) 
		{
			this->gPWM_L = 0;
			this->gPWM_R = 0;
		}
	}
	
	if ((this->gHStatus == HS_AUTO && this->AntL() == 0) || 
		this->gHStatus == HS_TOTMANN || this->gHStatus == HS_KEINE_ANTENNE) 
	{
		//Alles Stop
		PWM_R = 0;
		PWM_L = 0;
		PWM_M = 0;
	}
	else
	{
		if (this->gPWM_L < 0) lRed_pwm_l = 0;
		if (this->gPWM_R < 0) lRed_pwm_r = 0;
		if (this->gPWM_L - lRed_pwm_l < -100) gPWM_L = -100;
		if (this->gPWM_R - lRed_pwm_r < -100) gPWM_R = -100;
		
		//Distanz links und rechts prüfen
		this->gPWM_L = this->DistanzL();
		this->gPWM_R = this->DistanzR();
		
		//Wenn Strom zu groß, dann rückwärts (nur in Automatikmodus)
		if (this->gStromMW > gMaxMaehStrom && this->gPWM_M > 0 && AntL() == 2 && this->gHStatus == HS_AUTO)
		{
			PWM_L = (this->gPWM_L - lRed_pwm_l) * -1;
			PWM_R = (this->gPWM_R - lRed_pwm_r) * -1;
		}
		else
		{
			PWM_L = this->gPWM_L - lRed_pwm_l;
			PWM_R = this->gPWM_R - lRed_pwm_r;
		}
		
		PWM_M = this->gPWM_M;
	}
	
	
}

void tEdMa::Kompasskorrektur(void)
{
int lPWM_R = 0;
int lPWM_L = 0;

	int Puffer, PufferZwei;	
	
	PufferZwei = gPWM_Vor + gPWM_Komp_Korr;
	PufferZwei /= 2;

	Puffer = this->WinkelDiff(gWinkel_ist, gWinkel_soll);
	if(Puffer > 10)
	{
		lPWM_R = gPWM_Komp_Korr/2;
		lPWM_L = gPWM_Vor;
	}
	else if(Puffer > 3)
	{
		lPWM_R = gPWM_Komp_Korr;
		lPWM_L = gPWM_Vor;
	}
	else if(Puffer > 0)
	{
		lPWM_R = PufferZwei;
		lPWM_L = gPWM_Vor;
	}
	else if(Puffer < -10)
	{
		lPWM_R = gPWM_Vor;
		lPWM_L = gPWM_Komp_Korr/10;
	}
	else if(Puffer < -3)
	{
		lPWM_R = gPWM_Vor;
		lPWM_L = gPWM_Komp_Korr;
	}
	else if(Puffer < 0)
	{
		lPWM_R = gPWM_Vor;
		lPWM_L = PufferZwei;
	}
	else
	{
		lPWM_R = gPWM_Vor;
		lPWM_L = gPWM_Vor;
	}
	
	this->PWM(lPWM_R, lPWM_L);
	
}

char tEdMa::NotAus(void)
{
char lResult = 0;

	if (DIN_NOTAUS) lResult = 1; 
	return lResult;
	
}

char tEdMa::AntL(void)
{
char lResult = 0;

	lResult = this->gAnt_L;
	if (this->Distanz()) lResult = 1;	//Simmuliert ausserhalb
	
	return lResult;
	
}

char tEdMa::Distanz(void)
{
char lResult = 0;

	if (this->gDistanzStop > 0)
		if (this->gDistanz < this->gDistanzStop) lResult = 1;
	
	return lResult;
	
}

signed char tEdMa::DistanzL(void)
{
	
	if (this->gDistanzL < this->gDistanzLAct && this->gDistanzR < this->gDistanzRAct)
		return this->gPWM_L;
	
	if (this->gPWM_L > 0 && this->gPWM_R >0)
	{
		if (this->gDistanzLAct > 0)
			if (this->gDistanzL < this->gDistanzLAct) 
				return this->gPWM_L * this->gDistanzActPro / 100;
	}
	return this->gPWM_L;
	
}

signed char tEdMa::DistanzR(void)
{
	
	if (this->gDistanzL < this->gDistanzLAct && this->gDistanzR < this->gDistanzRAct)
		return this->gPWM_R;
	
	if (this->gPWM_L > 0 && this->gPWM_R >0)
	{	
		if (this->gDistanzRAct > 0)
			if (this->gDistanzR < this->gDistanzRAct) 
				return this->gPWM_R * this->gDistanzActPro / 100;
	}
	return this->gPWM_R;
	
}

char tEdMa::Gegen(void)
{
char lResult = 0;

	if (DIN_GEGEN) lResult = 1;
	if (this->Distanz()) lResult = 2;
	return lResult;
	
}

void tEdMa::LogPES(const char *aText)
{
char text[200];
char Zeit[50];
FILE *fp;
struct tm *myTm;

	if (this->gLoggen)
	{
		//aktuelle Uhrzeit
		time(&now);
		myTm = localtime(&now);
		sprintf(Zeit, "%04d-%02d-%02d %02d:%02d:%02d", 
				myTm->tm_year+1900, myTm->tm_mon+1, myTm->tm_mday, myTm->tm_hour, myTm->tm_min, myTm->tm_sec);
				
		sprintf(text, "%s,%s;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i;%s;%s\r\n", 
			Zeit, aText, this->gHStatus, PWM_R, PWM_L, PWM_M, this->gStromMR, this->gStromML, this->gStromMW, this->gDrive_Mode, 
			AntL(), this->gBatt, this->gWinkel_soll, this->gWinkel_ist, this->gDistanz, this->Gegen(),  
			this->gHS_Text, this->gZS_Text);
		if (fp = fopen("/var/www/html/log/pes.txt", "a"))
		{
			fprintf(fp, text);
			fclose(fp);
		}
	}
}

char tEdMa::Taster_Start(void)
{
static char lTaste = 0;
char lResult = 0;

	if (DIN_START != lTaste)
	{
		if (DIN_START) lResult = 1;
		lTaste = DIN_START;
		printf("Taste\n");
	}
	
	return lResult;
	
}

char tEdMa::TextToByte(char *aSpeicher, char *aText)
{
char n = 0;

	while (aText[n] != 0 && n < 40)
	{
		aSpeicher[n+1] = aText[n];
		n++;
		aSpeicher[n+1] = 0;
	}
	
	return n;
}

float tEdMa::Read_Float(char *aSpeicher)
{
float lResult = 0;

	lResult = *(float *)aSpeicher;
	
	return lResult;
	
}

void tEdMa::FloatToByte(char *aSpeicher, float aWert)
{
	aSpeicher[0] = ((unsigned char*)&aWert)[0];
	aSpeicher[1] = ((unsigned char*)&aWert)[1];
	aSpeicher[2] = ((unsigned char*)&aWert)[2];
	aSpeicher[3] = ((unsigned char*)&aWert)[3];
	
}

void tEdMa::Log()
{
char text[200];
char Zeit[50];
FILE *fp;
struct tm *myTm;

	if (this->gLoggen)
	{
		//aktuelle Uhrzeit
		time(&now);
		myTm = localtime(&now);
		sprintf(Zeit, "%04d-%02d-%02d %02d:%02d:%02d", 
				myTm->tm_year+1900, myTm->tm_mon+1, myTm->tm_mday, myTm->tm_hour, myTm->tm_min, myTm->tm_sec);
				
		sprintf(text, "%s,%i;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i;%s;%s\r\n", 
			Zeit, this->gHStatus, PWM_R, PWM_L, PWM_M, this->gStromMR, this->gStromML, this->gStromMW, this->gDrive_Mode, 
			AntL(), this->gBatt, this->gWinkel_soll, this->gWinkel_ist, this->gDistanz, this->Gegen(),  
			this->gHS_Text, this->gZS_Text);
		if (fp = fopen("/var/www/html/log/log.txt", "a"))
		{
			fprintf(fp, text);
			fclose(fp);
		}
	}
}

void tEdMa::PrintStatus()
{
	printf("HS: %i  MW: %i (%i), Lon: %f   Lat: %f   PWM_R: %i   PWM_L: %i   PWM_M: %i DM: %i AntL: %i V: %i Ws: %i Wi: %i D: %i Dl: %i Dr: %i G: %i N: %i DH: %i\n%s / %s\n", 
		this->gHStatus, this->gStromMW, this->gMaxMaehStrom, this->gGPSTelLo, this->gGPSTelLa, PWM_R, PWM_L, PWM_M, this->gDrive_Mode, AntL(), this->gBatt, this->gWinkel_soll, 
		this->gWinkel_ist, this->gDistanz, this->gDistanzL, this->gDistanzR, this->Gegen(), this->NotAus(), this->gDrehenHalb,   
		this->gHS_Text, this->gZS_Text);
}


