#ifndef tZeiten_H
#define tZeiten_H

#include <time.h>
#include <sys/time.h>
#include <sys/timeb.h>


#include <cstdio>

class tZeiten
{
	public:
	
		void SetSek(int aSekunde);
		char AbgelaufenSek(int aSekunde);		//Gibt 1 zurück, wenn Timer abgelaufen. Timer läuft weiter.
		char AbgelaufenMS(int aSekunde);		//Gibt 1 zurück, wenn Timer abgelaufen. Timer läuft weiter.
		void Reset(void);						//Timer zurücksetzen. Timer steht bis zum nächsten Abfragen.
		void Trigger(void);						//Timer nachtriggern (Zeit zurücksetzen, Timer läuft weiter.)
		
	private:
	
		long long int GetElapsedMicroSeconds();
		long long int GetElapsedMilliSeconds();
		long long int GetElapsedSeconds();
		
		long long int gAbgelaufeneZeit = 0;		//Ablaufende Zeit
		int gSekunde = 0;						//Timerzeit
		
};


char tZeiten::AbgelaufenSek(int aSekunde)
{

	//gSekunde setzen
	gSekunde = aSekunde;
	
	//Neustart
	if (this->gAbgelaufeneZeit == 0)
	{
		this->gAbgelaufeneZeit = this->GetElapsedSeconds() + gSekunde;
		return 0;
	}
	
	
	if (this->GetElapsedSeconds() < this->gAbgelaufeneZeit) 
	{
		//Läuft noch
		return 0;
	}
	else
	{
		//Abgelaufen
		this->gAbgelaufeneZeit = 0;
		return 1;
	}		
}

void tZeiten::SetSek(int aSekunde)
{
	//gSekunde setzen
	gSekunde = aSekunde;
}

char tZeiten::AbgelaufenMS(int aMilliSekunde)
{

	//gSekunde setzen
	gSekunde = aMilliSekunde;
	
	//Neustart
	if (this->gAbgelaufeneZeit == 0)
	{
		this->gAbgelaufeneZeit = this->GetElapsedMilliSeconds() + gSekunde;
		return 0;
	}
	
	
	if (this->GetElapsedMilliSeconds() < this->gAbgelaufeneZeit) 
	{
		//Läuft noch
		return 0;
	}
	else
	{
		//Abgelaufen
		this->gAbgelaufeneZeit = 0;
		return 1;
	}		
}

void tZeiten::Reset()
{
	gAbgelaufeneZeit = 0;
}	

void tZeiten::Trigger()
{
	this->gAbgelaufeneZeit = this->GetElapsedSeconds() + gSekunde;
}

long long int tZeiten::GetElapsedMicroSeconds()
{
struct timeval timer_usec; 
long long int timestamp_usec; /* timestamp in microsecond */
 
  if (!gettimeofday(&timer_usec, NULL)) {
    timestamp_usec = ((long long int) timer_usec.tv_sec) * 1000000ll + 
                        (long long int) timer_usec.tv_usec;
  }
  else {
    timestamp_usec = -1;
  }
  return timestamp_usec;
}

long long int tZeiten::GetElapsedMilliSeconds()
{
struct timeb timer_msec;
long long int timestamp_msec; /* timestamp in millisecond. */

	if (!ftime(&timer_msec)) {
		timestamp_msec = ((long long int) timer_msec.time) * 1000ll + 
                        (long long int) timer_msec.millitm;
	}
	else {
		timestamp_msec = -1;
	}
	return timestamp_msec;
}

long long int tZeiten::GetElapsedSeconds()
{
	return GetElapsedMilliSeconds() / 1000;
}

#endif

